var RY = RY || {};

(function() {
    /* Patch to allow code to work on desktop and mobile version. Would not be necessary if we use AUI mobile. */
    var contextPath;
    if (typeof ConfluenceMobile != "undefined") {
        contextPath = ConfluenceMobile.AppData.get("confluence-context-path");
    } else {
        contextPath = AJS.contextPath();
    }
    /* End Patch */

    //noinspection JSValidateTypes
    RY.Page = Backbone.Model.extend({

        /**
         * Constructs the url to this page.
         *
         * @return {String}
         */
        href: function() {
            // code is reused for desktop and mobile version
            return contextPath + this.get("url");
        },

        /**
         * Returns the number of days since this page was last visited.
         *
         * @return {Number}
         */
        daysSinceLastSeen: function() {
            return RY.util.daysSince(this.get('lastSeen'));
        }
    });


    RY.PageCollection = Backbone.Collection.extend({
        model: RY.Page,
        url: contextPath + "/rest/recentlyviewed/1.0/recent?includeTrashedContent=true",

        /**
         * Searches all pages for a title that matches query. Triggers a 'filter' event with an array of pages that match
         * the query.
         *
         * @param query
         */
        search: function(query) {
            var result;
            if (this._queryLength(query) === 0) {
                // empty search shows every thing
                result = this.models;
            } else {
                /**
                 * search algorithm:
                 * - split search string into separate words
                 * - try to find each word in the combination of page+space
                 * - return a result if each word was found
                 */
                var words = query.match(/[^\s-]+/g);
                result = this.filter(function (page) {
                    var title = page.get('title');
                    var space = page.get('space');
                    var haystack = (title + space).toLowerCase();

                    return _.all(words, function(word) {
                        return haystack.indexOf(word.toLowerCase()) !== -1;
                    });

                });
            }

            this.trigger("filter", result, query);
            return result;
        },

        _queryLength: function(query) {
            if (!String.prototype.trim) {
                return AJS.$.trim(query).length;
            }
            return query.trim().length;
        },

        /**
         * Sort pages by descending last seen order.
         */
        comparator: function(page) {
            return -(page.get('lastSeen'));
        }
    });
})();