var RY = RY || {};

/**
 * A search input component that filters a page collection.
 *
 * @type {*}
 */
RY.FilterView = Backbone.View.extend({
    className: "filter",

    events: {
        "input .filter-input": "onInput",
        "keyup .filter-input": "onInput",
        "keydown .filter-input" : "onKeydown"
    },

    initialize: function() {
        _.bindAll(this, 'render', 'onInput', 'onKeydown', 'search');
        this.navigationEvents = this.options.navigationEvents;

        // wait with the search to not be hit too often.
        this.onInput = RY.util.wait(this.onInput, 100, this);
    },

    render: function() {
        this.$input = this.$(".filter-input");
        return this;
    },

    onInput: function(e) {
        // don't act on arrow keys
        if (e && _.contains([37, 38, 39, 40], e.which)) {
            return;
        }

        this.search();
    },

    onKeydown: function(e) {
        switch (e.which) {
            case 13: // enter
                this.navigationEvents.trigger("select");
                e.preventDefault();
                e.stopPropagation();
                break;
            case 38: // up
                this.navigationEvents.trigger("previous");
                e.preventDefault();
                break;
            case 40: // down
                this.navigationEvents.trigger("next");
                e.preventDefault();
                break;
        }
    },

    /**
     * Searches the collection for the input of filter.
     *
     */
    search: function() {
        var text = this.$input.val();
        this.collection.search(text);
    }
});
