/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.gadgets.whitelist;

import com.atlassian.gadgets.directory.spi.ExternalGadgetSpec;
import com.atlassian.gadgets.directory.spi.ExternalGadgetSpecStore;
import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeed;
import com.atlassian.gadgets.directory.spi.SubscribedGadgetFeedStore;
import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.atlassian.plugins.whitelist.OutboundWhitelist;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import javax.annotation.Nullable;

public class ConfluenceURIWhitelist
implements Whitelist {
    private final ExternalGadgetSpecStore externalGadgetSpecStore;
    private final SubscribedGadgetFeedStore gadgetFeedStore;
    private final OutboundWhitelist whitelist;

    public ConfluenceURIWhitelist(ExternalGadgetSpecStore externalGadgetSpecStore, SubscribedGadgetFeedStore gadgetFeedStore, OutboundWhitelist whitelist) {
        this.externalGadgetSpecStore = externalGadgetSpecStore;
        this.gadgetFeedStore = gadgetFeedStore;
        this.whitelist = whitelist;
    }

    public boolean allows(URI uri) {
        return this.whitelist.isAllowed(uri) || this.matchesGadgetStoreHosts(uri);
    }

    private boolean matchesGadgetStoreHosts(URI uri) {
        return Iterables.any((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)this.externalGadgetSpecStore.entries(), this.extractUriFromExternalGadgetSpec()), (Iterable)Iterables.transform((Iterable)this.gadgetFeedStore.getAllFeeds(), this.extractUriFromSubscribedGadgetFeed())), this.matchesHost(uri));
    }

    private Function<? super ExternalGadgetSpec, URI> extractUriFromExternalGadgetSpec() {
        return new Function<ExternalGadgetSpec, URI>(){

            public URI apply(@Nullable ExternalGadgetSpec input) {
                return input != null ? input.getSpecUri() : null;
            }
        };
    }

    private Function<? super SubscribedGadgetFeed, URI> extractUriFromSubscribedGadgetFeed() {
        return new Function<SubscribedGadgetFeed, URI>(){

            public URI apply(@Nullable SubscribedGadgetFeed input) {
                return input != null ? input.getUri() : null;
            }
        };
    }

    private Predicate<URI> matchesHost(URI uri) {
        final String host = uri.getHost();
        return new Predicate<URI>(){

            public boolean apply(@Nullable URI input) {
                return input != null && host.equalsIgnoreCase(input.getHost());
            }
        };
    }
}

