define("confluence-user-profile/avatar-picker/upload-interceptor", [
    "jquery",
    "underscore"
],
function(
    $,
    _
) {
    "use strict";

    function UploadInterceptor(el, opts) {
        return this.init.apply(this, arguments);
    }

    UploadInterceptor.prototype.defaults = {
        replacementEl: undefined,
        clientFileHandler: null
    };

    UploadInterceptor.prototype.init = function(el, opts) {
        _.bindAll(this, 'onSelectFile', 'onReplacementClick');

        this._$el = $(el);
        this.options = _.extend({}, this.defaults, opts);

        this._$el.on('change', this.onSelectFile);

        if (this.options.replacementEl) {
            this._$replacement = $(this.options.replacementEl);
            this._$el.hide();

            // IE marks a file input as compromised if has a click triggered programmatically
            // and this prevents you from later submitting it's form via Javascript.
            // The work around is to use a label as the replacementEl with the `for` set to the file input,
            // but it requires that the click handler below not be bound. So regardless of whether you want
            // to use the workaround or not, the handler should not be bound in IE.
            if ($.browser && $.browser.msie) {
                if (!this._$replacement.is('label')) {
                    // Workaround is not being used, fallback to showing the regular file element and hide the replacement
                    this._$replacement.hide();
                    this._$el.show();
                }
            } else {
                this._$replacement.on('click', this.onReplacementClick);
            }
        }
    };

    UploadInterceptor.prototype.onSelectFile = function(e) {
        if ($(e.target).val() && this.options.clientFileHandler) {
            this.options.clientFileHandler.handleFiles(e.target.files, this._$el);
        }
    };

    UploadInterceptor.prototype.onReplacementClick = function(e) {
        e.preventDefault();
        this._$el.click();
    };

    UploadInterceptor.prototype.destroy = function() {
        this._$el.off('change', this.onSelectFile);
        this._$replacement.off('click', this.onReplacementClick);
    };

    return UploadInterceptor;
});