define("confluence-user-profile/avatar-picker/image-explorer",["jquery","underscore"],function(b,a){function c(e,d){this.init.apply(this,arguments)}c.scaleModes={fill:"fill",contain:"contain",containAndFill:"containAndFill"};c.zoomModes={localZoom:"localZoom",imageZoom:"imageZoom"};c.prototype.defaults={initialScaleMode:c.scaleModes.containAndFill,zoomMode:c.zoomModes.localZoom,emptyClass:"empty",scaleMax:1};c.prototype.init=function(e,d){this.$container=e;this._$imageView=this.$container.find(".image-explorer-image-view");this._$sourceImage=this.$container.find(".image-explorer-source");this._$mask=this.$container.find(".image-explorer-mask");this._$dragDelegate=this.$container.find(".image-explorer-drag-delegate");this.$scaleSlider=this.$container.find(".image-explorer-scale-slider");this.options=a.extend({},this.defaults,d);this.imageProperties={};a.bindAll(this,"getImageSrc","setImageSrc","initImage","initDragDelegate","initScaleSlider","setInitialScale","getFillScale","getContainedScale","getCircularContainedScale","sliderValToScale","scaleToSliderVal","updateImageScale","resetImagePosition","resetScaleSlider","toggleEmpty","get$ImageView","get$SourceImage","get$Mask","get$DragDelegate","getMaskedImageProperties","showError","clearError","hasValidImage","_resetFromError","_removeError");this.toggleEmpty(true);if(this._$sourceImage[0].naturalWidth){this.toggleEmpty(false);this.initImage({target:this._$sourceImage[0]})}this._$sourceImage.on("load",this.initImage);this.initDragDelegate();this.initScaleSlider()};c.prototype.getImageSrc=function(){return(this._$sourceImage)?this._$sourceImage.attr("src"):undefined};c.prototype.setImageSrc=function(d){if(this._$sourceImage){this._$sourceImage.attr("src","").attr("src",d)}};c.prototype.initImage=function(f){var d=f.target;this.imageProperties.naturalWidth=d.naturalWidth;this.imageProperties.naturalHeight=d.naturalHeight;this._removeError();this.toggleEmpty(false);this.setInitialScale()};c.prototype.initDragDelegate=function(){var d;this._$dragDelegate.draggable({start:a.bind(function(){d=this._$sourceImage.offset()},this),drag:a.bind(function(g,f){this._$sourceImage.offset({top:d.top+f.position.top-f.originalPosition.top,left:d.left+f.position.left-f.originalPosition.left})},this),revert:true,revertDuration:0})};c.prototype.initScaleSlider=function(){this.$scaleSlider.on("change",a.bind(function(d){this.updateImageScale(this.sliderValToScale(d.target.value))},this))};c.prototype.setInitialScale=function(){var h=this._$mask.width(),f=this._$mask.height(),e=this.imageProperties.naturalWidth,g=this.imageProperties.naturalHeight,d=1;this.minScale=1;switch(this.options.initialScaleMode){case c.scaleModes.fill:this.minScale=d=this.getFillScale(e,g,h,f);break;case c.scaleModes.contain:if(this._$mask.hasClass("circle-mask")){this.minScale=d=this.getCircularContainedScale(e,g,h/2)}else{this.minScale=d=this.getContainedScale(e,g,h,f)}break;case c.scaleModes.containAndFill:if(this._$mask.hasClass("circle-mask")){this.minScale=this.getCircularContainedScale(e,g,h/2)}else{this.minScale=this.getContainedScale(e,g,h,f)}d=this.getFillScale(e,g,h,f);break}this.maxScale=Math.max(d,this.options.scaleMax);this.resetScaleSlider(this.scaleToSliderVal(d));this.updateImageScale(d,c.zoomModes.imageZoom);this.resetImagePosition()};c.prototype.getFillScale=function(f,d,e,i){var h=e/f,g=i/d;return Math.max(h,g)};c.prototype.getContainedScale=function(f,d,e,i){var h=e/f,g=i/d;return Math.min(h,g)};c.prototype.getCircularContainedScale=function(e,d,h){var g=Math.atan(d/e),f=Math.cos(g)*h*2;return f/e};c.prototype.sliderValToScale=function(e){var d=e/(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"));return this.minScale+(d*(this.maxScale-this.minScale))};c.prototype.scaleToSliderVal=function(e){var d=(e-this.minScale)/(this.maxScale-this.minScale);return d*(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"))};c.prototype.updateImageScale=function(j,l){var i=Math.round(j*this.imageProperties.naturalWidth),d=Math.round(j*this.imageProperties.naturalHeight),f,e;l=l||this.options.zoomMode;switch(l){case c.zoomModes.imageZoom:f=-1*i/2;e=-1*d/2;break;case c.zoomModes.localZoom:var h=this._$sourceImage.width(),r=this._$sourceImage.height(),n=parseInt(this._$sourceImage.css("margin-left"),10),g=parseInt(this._$sourceImage.css("margin-top"),10),q=this._$sourceImage.position(),p=this._$imageView.width()/2,o=this._$imageView.height()/2,m=p-q.left-n,k=o-q.top-g,t=(m/h)*i,s=(k/r)*d;f=p-q.left-t;e=o-q.top-s;break}this._$sourceImage.width(i).height(d).css({"margin-left":Math.round(f)+"px","margin-top":Math.round(e)+"px"})};c.prototype.resetImagePosition=function(){this._$sourceImage.css({top:"50%",left:"50%"})};c.prototype.resetScaleSlider=function(d){this.$scaleSlider.val(d).removeClass("disabled").removeAttr("disabled")};c.prototype.toggleEmpty=function(d){this.$container.toggleClass(this.options.emptyClass,d)};c.prototype.get$ImageView=function(){return this._$imageView};c.prototype.get$SourceImage=function(){return this._$sourceImage};c.prototype.get$Mask=function(){return this._$mask};c.prototype.get$DragDelegate=function(){return this._$dragDelegate};c.prototype.getMaskedImageProperties=function(){var f=this._$sourceImage.width()/this.imageProperties.naturalWidth,e=this._$sourceImage.height()/this.imageProperties.naturalHeight,d=this._$mask.position(),g=this._$sourceImage.position();d.top+=parseInt(this._$mask.css("margin-top"),10);d.left+=parseInt(this._$mask.css("margin-left"),10);g.top+=parseInt(this._$sourceImage.css("margin-top"),10);g.left+=parseInt(this._$sourceImage.css("margin-left"),10);return{maskedAreaImageX:Math.round((d.left-g.left)/f),maskedAreaImageY:Math.round((d.top-g.top)/e),maskedAreaWidth:Math.round(this._$mask.width()/f),maskedAreaHeight:Math.round(this._$mask.height()/e)}};c.prototype.showError=function(f,e){this._removeError();this.toggleEmpty(true);this.$container.addClass("error");var d=b(aui.message.error({titleContent:f,content:e||"",closeable:true}));d.appendTo(this._$imageView).css({"margin-top":-1*d.outerHeight()/2}).attr("id","upload-error-message");d.on("messageClose",this._resetFromError);AJS.messages.setup()};c.prototype.clearError=function(){this._removeError();this._resetFromError()};c.prototype.hasValidImage=function(){return !!(this.getImageSrc()&&this._$sourceImage.prop("naturalWidth"))};c.prototype._resetFromError=function(){var d=this.hasValidImage();this.toggleEmpty(!d);this.$container.removeClass("error");a.isFunction(this.options.onErrorReset)&&this.options.onErrorReset(d?this.getImageSrc():undefined)};c.prototype._removeError=function(){this._$imageView.find(".aui-message.error").remove()};return c});