/**
 *  We can not use AMD require here because there is a delay to execute callback of AMD require so that
 *  "blueprint.wizard-register.ready" event is triggered early and it's too late to bind/listen on it.
 *  This change makes sure there is a way for event binding and executing correctly.
 */
(function() {
    var SoftwareProjectDialogView = require('confluence/softwareproject/software-project-dialog/dialog-view');
    var SoftwareProjectPanelView = require('confluence/softwareproject/software-project-dialog/panel-view');
    var config = require('confluence/softwareproject/util/config');

    'use strict';

    AJS.bind("blueprint.wizard-register.ready", function () {
        window.Confluence.Blueprint.setWizard(config.BLUE_SPRINT_SOFTWARE_PROJECT_KEY, function(wizard) {
            var softwareProjectView = new SoftwareProjectPanelView();

            wizard.on("submit." + config.DIALOG_PAGE_ID, function(e, state) {
                if (softwareProjectView.validate()) {
                    var selectedProject = softwareProjectView.formData.get('selectedProject');
                    state.pageData['jira-server-id'] = softwareProjectView.formData.get('selectedServer').id;
                    state.pageData['project-key'] = selectedProject.key;
                    state.pageData['project-name'] = selectedProject.name;
                    state.pageData.ContentPageTitle = state.pageData.name;

                    softwareProjectView.disableWholePanel();
                    return window.Confluence.SpaceBlueprint.CommonWizardBindings.submit(e, state);
                }

                return false;
            });

            wizard.on("pre-render." + config.DIALOG_PAGE_ID, function(e, state) {
                state.soyRenderContext['atlToken'] = AJS.Meta.get('atl-token');
                state.soyRenderContext['showSpacePermission'] = false;
            });

            wizard.on("post-render." + config.DIALOG_PAGE_ID, function(e, state) {
                softwareProjectView.render({
                    $el: state.$container,
                    dialog: new SoftwareProjectDialogView({el: state.$container.closest('.aui-dialog')}),
                    wizardData: state.wizardData
                });

                softwareProjectView.init();
                window.Confluence.SpaceBlueprint.CommonWizardBindings.postRender(e, state);
            });
        });
    });
}());