define('confluence/softwareproject/util/service', [
    'jquery',
    'underscore',
    'ajs'
],
function(
    $,
    _,
    AJS
) {
    'use strict';

    var cacheServerData = null;

    return {
        loadJiraServers: function() {
            var dfd = $.Deferred();

            if (cacheServerData) {
                dfd.resolve(cacheServerData);
                return dfd.promise();
            }

            $.ajax({
                    dataType: 'json',
                    url: AJS.contextPath() + '/rest/jiraanywhere/1.0/servers'
                })
                .done(function(servers) {
                    var primaryServer = _.findWhere(servers, {selected: true});

                    cacheServerData = {
                        servers: servers,
                        primaryServer: primaryServer
                    };

                    dfd.resolve(cacheServerData);
                })
                .fail(dfd.reject);

            return dfd.promise();
        },

        loadProjectsData: function(serverId, nameFilter) {
            nameFilter = nameFilter || '';

            return $.ajax({
                dataType: 'json',
                url: AJS.contextPath() +'/rest/jira-integration/1.0/servers/' + serverId + '/projects?name=' + encodeURIComponent(nameFilter),
                timeout: AJS.Meta.getNumber('connection-timeout')
            });
        },

        resetCachingData: function() {
            cacheServerData = null;
        }
    };
});

