/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.rpc.AlreadyExistsException;
import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.VersionMismatchException;
import com.atlassian.confluence.rpc.soap.ConfluenceSoapService;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntrySummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteClusterInformation;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentPermissionSet;
import com.atlassian.confluence.rpc.soap.beans.RemoteContentSummaries;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemoteNodeStatus;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemotePageHistory;
import com.atlassian.confluence.rpc.soap.beans.RemotePageSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePageUpdateOptions;
import com.atlassian.confluence.rpc.soap.beans.RemotePermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceGroup;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import com.atlassian.confluence.rpc.soap.services.AdminSoapService;
import com.atlassian.confluence.rpc.soap.services.AttachmentsSoapService;
import com.atlassian.confluence.rpc.soap.services.BlogsSoapService;
import com.atlassian.confluence.rpc.soap.services.LabelsSoapService;
import com.atlassian.confluence.rpc.soap.services.NotificationsSoapService;
import com.atlassian.confluence.rpc.soap.services.PagesSoapService;
import com.atlassian.confluence.rpc.soap.services.SpacesSoapService;
import com.atlassian.confluence.rpc.soap.services.UsersSoapService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConfluenceSoapServiceImpl
implements ConfluenceSoapService {
    public static final List VIEW_SPACE_PERMISSION_TYPES = Arrays.asList("VIEWSPACE");
    public static final List MODIFY_SPACE_PERMISSION_TYPES = Arrays.asList("EDITSPACE");
    public static final List ADMINISTER_PERMISSION_TYPES = Arrays.asList("ADMINISTRATECONFLUENCE", "SYSTEMADMINISTRATOR");
    public static final List SPACE_ADMIN_PERMISSION_TYPES = Arrays.asList("SETSPACEPERMISSIONS");
    public static final List REMOVE_PAGE_PERMISSION_TYPES = Arrays.asList("REMOVEPAGE");
    public static final List EXPORT_SPACE_PERMISSION_TYPES = Arrays.asList("EXPORTSPACE");
    private SpacesSoapService spacesService;
    private PagesSoapService pagesService;
    private UsersSoapService usersService;
    private BlogsSoapService blogsService;
    private AdminSoapService adminSoapService;
    private LabelsSoapService labelsSoapService;
    private AttachmentsSoapService attachmentsService;
    private NotificationsSoapService notificationsService;

    public void setSpacesSoapService(SpacesSoapService spacesService) {
        this.spacesService = spacesService;
    }

    public void setPagesSoapService(PagesSoapService pagesService) {
        this.pagesService = pagesService;
    }

    public void setUsersSoapService(UsersSoapService usersService) {
        this.usersService = usersService;
    }

    public void setBlogsSoapService(BlogsSoapService blogsService) {
        this.blogsService = blogsService;
    }

    public void setGlobalSoapService(AdminSoapService adminSoapService) {
        this.adminSoapService = adminSoapService;
    }

    public void setAdminSoapService(AdminSoapService adminSoapService) {
        this.adminSoapService = adminSoapService;
    }

    public void setLabelsSoapService(LabelsSoapService labelsSoapService) {
        this.labelsSoapService = labelsSoapService;
    }

    public void setAttachmentsSoapService(AttachmentsSoapService attachmentsService) {
        this.attachmentsService = attachmentsService;
    }

    public void setNotificationsSoapService(NotificationsSoapService notificationsSoapService) {
        this.notificationsService = notificationsSoapService;
    }

    @Override
    public String login(String username, String password) throws RemoteException {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    @Override
    public boolean logout(String token) {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    @Override
    public RemoteSpaceSummary[] getSpaces(String token) throws RemoteException {
        return this.spacesService.getSpaces();
    }

    @Override
    public RemoteSpaceSummary[] getSpacesInGroup(String token, String spaceGroupKey) throws RemoteException {
        return this.spacesService.getSpacesInGroup(spaceGroupKey);
    }

    @Override
    public RemoteSpace addSpace(String token, RemoteSpace space) throws RemoteException {
        return this.spacesService.addSpace(space);
    }

    @Override
    public RemoteSpace storeSpace(String token, RemoteSpace remoteSpace) throws RemoteException {
        return this.spacesService.storeSpace(remoteSpace);
    }

    @Override
    public RemoteSpaceGroup addSpaceGroup(String token, RemoteSpaceGroup spaceGroup) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.spacesService.addSpaceGroup(spaceGroup);
    }

    @Override
    public RemoteSpaceGroup getSpaceGroup(String token, String spaceGroupKey) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException {
        return this.spacesService.getSpaceGroup(spaceGroupKey);
    }

    @Override
    public RemoteSpaceGroup[] getSpaceGroups(String token) throws InvalidSessionException, RemoteException {
        return this.spacesService.getSpaceGroups();
    }

    @Override
    public boolean removeSpaceGroup(String token, String spaceGroupKey) throws RemoteException {
        return this.spacesService.removeSpaceGroup(spaceGroupKey);
    }

    @Override
    public RemoteSpace addPersonalSpace(String token, RemoteSpace space, String username) throws RemoteException {
        return this.spacesService.addPersonalSpace(space, username);
    }

    @Override
    @Deprecated
    public boolean convertToPersonalSpace(String token, String userName, String spaceKey, String newName, boolean updateLinks) throws RemoteException {
        return this.spacesService.convertToPersonalSpace(userName, spaceKey, newName, updateLinks);
    }

    @Override
    public Boolean removeSpace(String token, String spaceKey) throws RemoteException {
        return this.spacesService.removeSpace(spaceKey);
    }

    @Override
    public RemoteSpace getSpace(String token, String spaceKey) throws RemoteException {
        return this.spacesService.getSpace(spaceKey);
    }

    @Override
    public String[] getPermissions(String token, String spaceKey) throws RemoteException {
        return this.spacesService.getPermissions(spaceKey);
    }

    @Override
    public String[] getPermissionsForUser(String token, String spaceKey, String userName) throws InvalidSessionException, RemoteException {
        return this.spacesService.getPermissions(spaceKey, userName);
    }

    @Override
    public boolean addPermissionToSpace(String token, String permission, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionToSpace(permission, remoteEntityName, spaceKey);
    }

    @Override
    public boolean addPermissionsToSpace(String token, String[] permissions, String remoteEntityName, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionsToSpace(permissions, remoteEntityName, spaceKey);
    }

    @Override
    public boolean removePermissionFromSpace(String token, String permission, String remoteEntityName, String spaceKey) throws NotPermittedException, RemoteException {
        return this.spacesService.removePermissionFromSpace(permission, remoteEntityName, spaceKey);
    }

    @Override
    public boolean addGlobalPermission(String token, String permission, String remoteEntityName) throws NotPermittedException, RemoteException {
        return this.spacesService.addGlobalPermission(permission, remoteEntityName);
    }

    @Override
    public boolean addGlobalPermissions(String token, String[] permissions, String remoteEntityName) throws NotPermittedException, RemoteException {
        return this.spacesService.addGlobalPermissions(permissions, remoteEntityName);
    }

    @Override
    public boolean removeGlobalPermission(String token, String permission, String remoteEntityName) throws RemoteException {
        return this.spacesService.removeGlobalPermission(permission, remoteEntityName);
    }

    @Override
    public boolean addAnonymousUsePermission(String token) throws RemoteException {
        return this.spacesService.addAnonymousUsePermission();
    }

    @Override
    public boolean removeAnonymousUsePermission(String token) throws RemoteException {
        return this.spacesService.removeAnonymousUserPermission();
    }

    @Override
    public boolean addAnonymousViewUserProfilePermission(String token) throws RemoteException {
        return this.spacesService.addAnonymousViewUserProfilePermission();
    }

    @Override
    public boolean removeAnonymousViewUserProfilePermission(String token) throws RemoteException {
        return this.spacesService.removeAnonymousViewUserProfilePermission();
    }

    @Override
    public boolean addAnonymousPermissionToSpace(String token, String permission, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionToSpace(permission, null, spaceKey);
    }

    @Override
    public boolean addAnonymousPermissionsToSpace(String token, String[] permissions, String spaceKey) throws RemoteException {
        return this.spacesService.addPermissionsToSpace(permissions, null, spaceKey);
    }

    @Override
    public boolean removeAnonymousPermissionFromSpace(String token, String permission, String spaceKey) throws NotPermittedException, RemoteException {
        return this.spacesService.removePermissionFromSpace(permission, null, spaceKey);
    }

    @Override
    public String[] getSpaceLevelPermissions(String token) throws RemoteException {
        return this.spacesService.getSpaceLevelPermissions();
    }

    @Override
    public RemotePageSummary[] getPages(String token, String spaceKey) throws RemoteException {
        return this.pagesService.getPages(spaceKey);
    }

    @Override
    public RemotePage getPage(String token, String spaceKey, String pageTitle) throws InvalidSessionException, RemoteException {
        return this.pagesService.getPage(spaceKey, pageTitle);
    }

    @Override
    public RemotePage getPage(String token, long pageId) throws RemoteException {
        return this.pagesService.getPage(pageId);
    }

    @Override
    public RemoteComment[] getComments(String token, long pageId) throws RemoteException {
        return this.pagesService.getComments(pageId);
    }

    @Override
    public RemoteComment getComment(String token, long commentId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getComment(commentId);
    }

    @Override
    public RemoteComment addComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.addComment(comment);
    }

    @Override
    public RemoteComment editComment(String token, RemoteComment comment) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.editComment(comment);
    }

    @Override
    public boolean removeComment(String token, long commentId) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.removeComment(commentId);
    }

    @Override
    public RemotePageSummary[] getTopLevelPages(String token, String spaceKey) throws RemoteException {
        return this.pagesService.getTopLevelPages(spaceKey);
    }

    @Override
    public RemotePageSummary[] getAncestors(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getAncestors(pageId);
    }

    @Override
    public RemotePageSummary[] getChildren(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getChildren(pageId);
    }

    @Override
    public RemotePageSummary[] getDescendents(String token, long pageId) throws InvalidSessionException, RemoteException {
        return this.pagesService.getDescendents(pageId);
    }

    @Override
    public RemoteAttachment[] getAttachments(String token, long pageId) throws RemoteException {
        return this.pagesService.getAttachments(pageId);
    }

    @Override
    public RemotePageHistory[] getPageHistory(String token, long pageId) throws RemoteException {
        return this.pagesService.getPageHistory(pageId);
    }

    @Override
    public boolean watchPage(String token, long pageId) throws RemoteException {
        return this.notificationsService.watchPage(pageId);
    }

    @Override
    public boolean watchSpace(String token, String spaceKey) throws RemoteException {
        return this.notificationsService.watchSpace(spaceKey);
    }

    @Override
    public boolean watchPageForUser(String token, long pageId, String username) throws RemoteException {
        return this.notificationsService.watchPageForUser(pageId, username);
    }

    @Override
    public boolean isWatchingPage(String token, long pageId, String username) throws RemoteException {
        return this.notificationsService.isWatchingPage(pageId, username);
    }

    @Override
    public boolean isWatchingSpace(String token, String spaceKey, String username) throws RemoteException {
        return this.notificationsService.isWatchingSpace(spaceKey, username);
    }

    @Override
    public boolean isWatchingSpaceForType(String token, String spaceKey, String contentType, String username) throws RemoteException {
        return this.notificationsService.isWatchingSpaceForType(spaceKey, contentType, username);
    }

    @Override
    public RemoteUser[] getWatchersForPage(String token, long pageId) throws RemoteException {
        return this.notificationsService.getWatchersForPage(pageId);
    }

    @Override
    public RemoteUser[] getWatchersForSpace(String token, String spaceKey) throws RemoteException {
        return this.notificationsService.getWatchersForSpace(spaceKey);
    }

    @Override
    public RemoteSearchResult[] search(String token, String query, int maxResults) throws RemoteException {
        return this.pagesService.search(query, maxResults);
    }

    @Override
    public RemoteSearchResult[] search(String token, String query, Map params, int maxResults) throws RemoteException {
        return this.pagesService.search(query, params, maxResults);
    }

    @Override
    public RemoteBlogEntry getBlogEntryByDayAndTitle(String token, String spaceKey, int dayOfMonth, String postTitle) throws RemoteException {
        return this.blogsService.getBlogEntryByDayAndTitle(spaceKey, dayOfMonth, postTitle);
    }

    @Override
    public RemoteBlogEntry getBlogEntryByDateAndTitle(String token, String spaceKey, int year, int month, int dayOfMonth, String postTitle) throws RemoteException {
        return this.blogsService.getBlogEntryByDateAndTitle(spaceKey, year, month, dayOfMonth, postTitle);
    }

    @Override
    public String renderContent(String token, String spaceKey, long pageId, String newContent) throws RemoteException {
        return this.pagesService.renderContent(spaceKey, pageId, newContent);
    }

    @Override
    public String renderContent(String token, String spaceKey, long pageId, String newContent, Map renderParameters) throws RemoteException {
        return this.pagesService.renderContent(spaceKey, pageId, newContent, renderParameters);
    }

    @Override
    public RemoteAttachment addAttachment(String token, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException {
        return this.attachmentsService.addAttachment(attachment.getPageId(), attachment, attachmentData);
    }

    @Override
    public RemoteAttachment addAttachment(String token, long contentId, RemoteAttachment attachment, byte[] attachmentData) throws RemoteException {
        return this.attachmentsService.addAttachment(contentId, attachment, attachmentData);
    }

    @Override
    public RemoteAttachment getAttachment(String token, long contentId, String fileName, int version) throws RemoteException {
        return this.attachmentsService.getAttachment(contentId, fileName, version);
    }

    @Override
    public byte[] getAttachmentData(String token, long contentId, String fileName, int version) throws RemoteException {
        return this.attachmentsService.getAttachmentData(contentId, fileName, version);
    }

    @Override
    public boolean removeAttachment(String token, long contentId, String fileName) throws RemoteException {
        return this.attachmentsService.removeAttachment(contentId, fileName);
    }

    @Override
    public boolean moveAttachment(String token, long originalContentId, String originalFileName, long newContentId, String newFileName) throws RemoteException {
        return this.attachmentsService.moveAttachment(originalContentId, originalFileName, newContentId, newFileName);
    }

    @Override
    public Boolean movePageToTopLevel(String token, long pageId, String targetSpaceKey) throws RemoteException {
        return this.pagesService.movePageToTopLevel(pageId, targetSpaceKey);
    }

    @Override
    public Boolean movePage(String token, long sourcePageId, long targetPageId, String position) throws RemoteException {
        return this.pagesService.movePage(sourcePageId, targetPageId, position);
    }

    @Override
    public Boolean removePage(String token, long pageId) throws RemoteException {
        return this.pagesService.removePage(pageId);
    }

    @Override
    public RemotePage storePage(String token, RemotePage rpage) throws RemoteException {
        return this.pagesService.storePage(rpage);
    }

    @Override
    public RemotePage updatePage(String token, RemotePage page, RemotePageUpdateOptions options) throws VersionMismatchException, NotPermittedException, InvalidSessionException, RemoteException {
        return this.pagesService.updatePage(page, options);
    }

    @Override
    public RemotePermission[] getPagePermissions(String token, long pageId) throws RemoteException {
        return this.pagesService.getPermissions(pageId);
    }

    @Override
    public RemoteContentSummaries getTrashContents(String token, String spaceKey, int offset, int count) throws RemoteException {
        return this.pagesService.getTrashContents(spaceKey, offset, count);
    }

    @Override
    public Boolean purgeFromTrash(String token, String spaceKey, long pageId) throws RemoteException {
        return this.pagesService.purgeFromTrash(spaceKey, pageId);
    }

    @Override
    public Boolean emptyTrash(String token, String spaceKey) throws RemoteException {
        return this.pagesService.emptyTrash(spaceKey);
    }

    @Override
    public RemoteBlogEntry getBlogEntry(String token, long entryId) throws RemoteException {
        return this.blogsService.getBlogEntry(entryId);
    }

    @Override
    public RemoteBlogEntrySummary[] getBlogEntries(String token, String spaceKey) throws RemoteException {
        return this.blogsService.getBlogEntries(spaceKey);
    }

    @Override
    public RemoteBlogEntry storeBlogEntry(String token, RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        return this.blogsService.storeBlogEntry(remoteBlogEntry);
    }

    @Override
    public String[] getGroups(String token) throws RemoteException {
        return this.usersService.getGroups();
    }

    @Override
    public boolean hasGroup(String token, String groupname) throws InvalidSessionException, RemoteException {
        return this.usersService.hasGroup(groupname);
    }

    @Override
    public boolean addGroup(String token, String groupname) throws RemoteException {
        return this.usersService.addGroup(groupname);
    }

    @Override
    public boolean removeGroup(String token, String groupname, String defaultGroupName) throws RemoteException {
        return this.usersService.removeGroup(groupname, defaultGroupName);
    }

    @Override
    public boolean removeAllPermissionsForGroup(String token, String groupname) throws RemoteException {
        return this.usersService.removeAllPermissionsForGroup(groupname);
    }

    @Override
    public String[] getUserGroups(String token, String username) throws RemoteException {
        return this.usersService.getUserGroups(username);
    }

    @Override
    public boolean addUserToGroup(String token, String username, String groupname) throws RemoteException {
        return this.usersService.addUserToGroup(username, groupname);
    }

    @Override
    public boolean removeUserFromGroup(String token, String username, String groupname) throws RemoteException {
        return this.usersService.removeUserFromGroup(username, groupname);
    }

    @Override
    public RemoteUser getUser(String token, String username) throws RemoteException {
        return this.usersService.getUser(username);
    }

    @Override
    public boolean setUserPreferenceBoolean(String token, String username, String key, boolean value) throws InvalidSessionException, RemoteException {
        return this.usersService.setUserPreferenceBoolean(username, key, value);
    }

    @Override
    public boolean getUserPreferenceBoolean(String token, String username, String key) throws InvalidSessionException, RemoteException {
        return this.usersService.getUserPreferenceBoolean(username, key);
    }

    @Override
    public boolean setUserPreferenceLong(String token, String username, String key, long value) throws InvalidSessionException, RemoteException {
        return this.usersService.setUserPreferenceLong(username, key, value);
    }

    @Override
    public long getUserPreferenceLong(String token, String username, String key) throws InvalidSessionException, RemoteException {
        return this.usersService.getUserPreferenceLong(username, key);
    }

    @Override
    public boolean setUserPreferenceString(String token, String username, String key, String value) throws InvalidSessionException, RemoteException {
        return this.usersService.setUserPreferenceString(username, key, value);
    }

    @Override
    public String getUserPreferenceString(String token, String username, String key) throws InvalidSessionException, RemoteException {
        return this.usersService.getUserPreferenceString(username, key);
    }

    @Override
    public boolean hasUser(String token, String username) throws InvalidSessionException, RemoteException {
        return this.usersService.hasUser(username);
    }

    @Override
    public void addUser(String token, RemoteUser remoteUser, String password) throws RemoteException {
        this.usersService.addUser(remoteUser, password);
    }

    @Override
    public boolean removeUser(String token, String username) throws RemoteException {
        return this.usersService.removeUser(username);
    }

    @Override
    public boolean editUser(String token, RemoteUser remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.editUser(remoteUser);
    }

    @Override
    public boolean deactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.deactivateUser(username);
    }

    @Override
    public boolean reactivateUser(String token, String username) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.reactivateUser(username);
    }

    @Override
    public boolean isActiveUser(String token, String username) throws NotPermittedException, RemoteException {
        return this.usersService.isActiveUser(username);
    }

    @Override
    public String[] getActiveUsers(String token, boolean viewAll) throws InvalidSessionException, RemoteException {
        return this.usersService.getActiveUsers(viewAll);
    }

    @Override
    public boolean setUserInformation(String token, RemoteUserInformation userInfo) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.setUserInformation(userInfo);
    }

    @Override
    public RemoteUserInformation getUserInformation(String token, String username) throws InvalidSessionException, RemoteException {
        return this.usersService.getUserInformation(username);
    }

    @Override
    public boolean changeMyPassword(String token, String oldPass, String newPass) throws InvalidSessionException, RemoteException {
        return this.usersService.changeMyPassword(oldPass, newPass);
    }

    @Override
    public boolean changeUserPassword(String token, String username, String newPass) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.changeUserPassword(username, newPass);
    }

    @Override
    public boolean addProfilePicture(String token, String userName, String fileName, String mimeType, byte[] pictureData) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.addProfilePicture(userName, fileName, mimeType, pictureData);
    }

    @Override
    public RemoteServerInfo getServerInfo(String token) throws RemoteException {
        return this.adminSoapService.getServerInfo();
    }

    @Override
    public String exportSpace(String token, String spaceKey, String exportType) throws RemoteException {
        return this.spacesService.exportSpace(spaceKey, exportType);
    }

    @Override
    public String exportSpace(String token, String spaceKey, String exportType, boolean exportAll) throws RemoteException {
        return this.spacesService.exportSpace(spaceKey, exportType, exportAll);
    }

    @Override
    public String exportSite(String token, boolean exportAttachments) throws RemoteException {
        return this.adminSoapService.exportSite(exportAttachments);
    }

    @Override
    public boolean importSpace(String token, byte[] importData) throws RemoteException {
        return this.adminSoapService.importSpace(importData);
    }

    @Override
    public boolean flushIndexQueue(String token) throws RemoteException {
        return this.adminSoapService.flushIndexQueue();
    }

    @Override
    public boolean clearIndexQueue(String token) throws RemoteException {
        return this.adminSoapService.clearIndexQueue();
    }

    @Override
    public RemoteClusterInformation getClusterInformation(String token) throws RemoteException {
        return this.adminSoapService.getClusterInformation();
    }

    @Override
    public RemoteNodeStatus[] getClusterNodeStatuses(String token) throws RemoteException {
        return this.adminSoapService.getClusterNodeStatuses();
    }

    @Override
    public RemoteLabel[] getLabelsById(String token, long objectId) throws RemoteException {
        return this.labelsSoapService.getLabelsById(objectId);
    }

    @Override
    public RemoteLabel[] getMostPopularLabels(String token, int maxCount) throws RemoteException {
        return this.labelsSoapService.getMostPopularLabels(maxCount);
    }

    @Override
    public RemoteLabel[] getMostPopularLabelsInSpace(String token, String spaceKey, int maxCount) throws RemoteException {
        return this.labelsSoapService.getMostPopularLabelsInSpace(spaceKey, maxCount);
    }

    @Override
    public RemoteLabel[] getRecentlyUsedLabels(String token, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRecentlyUsedLabels(maxResults);
    }

    @Override
    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String token, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRecentlyUsedLabelsInSpace(spaceKey, maxResults);
    }

    @Override
    public RemoteSpace[] getSpacesWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getSpacesWithLabel(labelName);
    }

    @Override
    public RemoteLabel[] getRelatedLabels(String token, String labelName, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRelatedLabels(labelName, maxResults);
    }

    @Override
    public RemoteLabel[] getRelatedLabelsInSpace(String token, String labelName, String spaceKey, int maxResults) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRelatedLabelsInSpace(labelName, spaceKey, maxResults);
    }

    @Override
    public RemoteLabel[] getLabelsByDetail(String token, String labelName, String namespace, String spaceKey, String owner) throws InvalidSessionException, RemoteException, NotPermittedException {
        return this.labelsSoapService.getLabelsByDetail(labelName, namespace, spaceKey, owner);
    }

    @Override
    public RemoteSearchResult[] getLabelContentById(String token, long labelId) throws RemoteException {
        return this.labelsSoapService.getLabelContentById(labelId);
    }

    @Override
    public RemoteSearchResult[] getLabelContentByName(String token, String labelName) throws RemoteException {
        return this.labelsSoapService.getLabelContentByName(labelName);
    }

    @Override
    public RemoteSearchResult[] getLabelContentByObject(String token, RemoteLabel labelObject) throws RemoteException {
        return this.labelsSoapService.getLabelContentByObject(labelObject);
    }

    @Override
    public RemoteSpace[] getSpacesContainingContentWithLabel(String token, String labelName) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getSpacesContainingContentWithLabel(labelName);
    }

    @Override
    public boolean addLabelByName(String token, String labelName, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelByName(labelName, objectId);
    }

    @Override
    public boolean addLabelById(String token, long labelId, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelById(labelId, objectId);
    }

    @Override
    public boolean addLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelByObject(labelObject, objectId);
    }

    @Override
    public boolean addLabelByNameToSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.labelsSoapService.addLabelByNameToSpace(labelName, spaceKey);
    }

    @Override
    public boolean removeLabelByName(String token, String labelName, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelByName(labelName, objectId);
    }

    @Override
    public boolean removeLabelById(String token, long labelId, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelById(labelId, objectId);
    }

    @Override
    public boolean removeLabelByObject(String token, RemoteLabel labelObject, long objectId) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelByObject(labelObject, objectId);
    }

    @Override
    public boolean removeLabelByNameFromSpace(String token, String labelName, String spaceKey) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.labelsSoapService.removeLabelByNameFromSpace(labelName, spaceKey);
    }

    @Override
    public RemoteContentPermissionSet[] getContentPermissionSets(String token, long contentId) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.pagesService.getContentPermissionSets(contentId);
    }

    @Override
    public RemoteContentPermissionSet getContentPermissionSet(String token, long contentId, String permissionType) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.pagesService.getContentPermissionSet(contentId, permissionType);
    }

    @Override
    public boolean setContentPermissions(String token, long contentId, String permissionType, RemoteContentPermission[] remoteContentPermissions) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.pagesService.setContentPermissions(contentId, permissionType, remoteContentPermissions);
    }

    @Override
    public boolean setEnableWysiwyg(String token, boolean value) throws RemoteException {
        return this.adminSoapService.setEnableWysiwyg(value);
    }

    @Override
    public boolean setEnableAnonymousAccess(String token, boolean value) throws RemoteException {
        return this.adminSoapService.setEnableAnonymousAccess(value);
    }

    @Override
    public boolean isPluginEnabled(String token, String pluginKey) {
        return this.adminSoapService.isPluginEnabled(pluginKey);
    }

    @Override
    public boolean isPluginInstalled(String token, String pluginKey) {
        return this.adminSoapService.isPluginInstalled(pluginKey);
    }

    @Override
    public boolean installPlugin(String token, String pluginFileName, byte[] pluginData) throws RemoteException {
        return this.adminSoapService.installPlugin(pluginFileName, pluginData);
    }
}

