/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.service;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.requestaccess.exception.RecipientNotFoundException;
import com.atlassian.confluence.plugins.requestaccess.service.UserNotificationService;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserNotificationServiceImpl
implements UserNotificationService {
    private final PermissionManager permissionManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;

    @Autowired
    public UserNotificationServiceImpl(@ComponentImport PermissionManager permissionManager, @ComponentImport SpaceManager spaceManager, @ComponentImport UserAccessor userAccessor) {
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public ConfluenceUser findRequestAccessRecipient(AbstractPage page) throws RecipientNotFoundException {
        ConfluenceUser pageCreator;
        ConfluenceUser lastModifier;
        if (page instanceof Page) {
            lastModifier = page.getLastModifier();
            if (this.hasPermissionsToGrantAccess((User)lastModifier, page)) {
                return lastModifier;
            }
        } else {
            lastModifier = null;
        }
        if ((pageCreator = page.getCreator()) != null && !pageCreator.equals(lastModifier) && this.hasPermissionsToGrantAccess((User)pageCreator, page)) {
            return pageCreator;
        }
        ConfluenceUser spaceAdminUser = null;
        List spaceAdmins = this.spaceManager.getSpaceAdmins(page.getSpace());
        for (User spaceAdmin : spaceAdmins) {
            if (!this.hasPermissionsToGrantAccess(spaceAdmin, page)) continue;
            spaceAdminUser = this.userAccessor.getUserByName(spaceAdmin.getName());
            break;
        }
        if (spaceAdminUser != null) {
            return spaceAdminUser;
        }
        throw new RecipientNotFoundException("No recipient for the request access notification was found.");
    }

    private boolean hasPermissionsToGrantAccess(User user, AbstractPage page) {
        return this.permissionManager.hasPermission(user, Permission.VIEW, (Object)page) && this.permissionManager.hasPermission(user, Permission.SET_PERMISSIONS, (Object)page);
    }
}

