/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.requestaccess.contextprovider;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InheritedContentPermissionManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.PageNotPermittedAction;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.user.User;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RestrictedPageContextProvider
implements ContextProvider {
    protected final PageManager pageManager;
    protected final InheritedContentPermissionManager inheritedContentPermissionManager;
    protected final SpacePermissionManager spacePermissionManager;
    protected final MailServerManager mailServerManager;

    public RestrictedPageContextProvider(@ComponentImport PageManager pageManager, @ComponentImport InheritedContentPermissionManager inheritedContentPermissionManager, @ComponentImport SpacePermissionManager spacePermissionManager, @ComponentImport MailServerManager mailServerManager) {
        this.pageManager = Objects.requireNonNull(pageManager);
        this.inheritedContentPermissionManager = Objects.requireNonNull(inheritedContentPermissionManager);
        this.spacePermissionManager = Objects.requireNonNull(spacePermissionManager);
        this.mailServerManager = Objects.requireNonNull(mailServerManager);
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        if (!(context.get("action") instanceof PageNotPermittedAction)) {
            return context;
        }
        ConfluenceUser user = (ConfluenceUser)context.get("user");
        if (user == null) {
            return context;
        }
        PageNotPermittedAction action = (PageNotPermittedAction)context.get("action");
        if (action.getPage() == null) {
            AbstractPage draft = null;
            if (action.getDraftId() > 0L) {
                draft = this.pageManager.getAbstractPage(action.getDraftId());
            }
            if (draft == null) {
                return context;
            }
            action.setPage(draft);
        }
        List inheritedPermissions = this.inheritedContentPermissionManager.getInheritedContentPermissionSets((ContentEntityObject)action.getPage());
        boolean isUnpublishedDraft = action.getPage().getContentStatus() != null && action.getPage().getContentStatus().equals("draft") && action.getPage().isUnpublished();
        String spacePermission = action.getPage().getType().equals("blogpost") ? "EDITBLOG" : "EDITSPACE";
        boolean isUnpublishedDraftRestrictedBySpacePermissions = isUnpublishedDraft && !this.spacePermissionManager.hasPermission(spacePermission, action.getPage().getSpace(), (User)user);
        context.put("contentType", action.getPage().getType());
        context.put("inheritedPermissions", inheritedPermissions.size() > 0);
        context.put("shouldDisplayRequestAccessButton", this.mailServerManager.isDefaultSMTPMailServerDefined());
        context.put("isUnpublishedDraft", isUnpublishedDraft);
        context.put("isUnpublishedDraftRestrictedBySpacePermissions", isUnpublishedDraftRestrictedBySpacePermissions);
        return context;
    }
}

