require([
    'ajs',
    'jquery',
    'confluence/legacy',
    'confluence/meta',
    'confluence/request-access/request-access-util'
], function (AJS,
             $,
             Confluence,
             Meta,
             AccessUtil) {
    AJS.toInit(function () {
        var pageId = Meta.get("page-id");
        var requestAccessUser = Meta.get("remote-user");
        var $restrictedPage = $(".request-access-container");
        var $requestAccessButton = $(".request-access-container button");
        var accessType = $requestAccessButton.data('access-type');
        var isDirectEditorLink = $("#invite-to-edit-draft").length;

        if (isDirectEditorLink) {
            pageId = $("#invite-to-edit-draft").data("draft-id");
        }

        if ($restrictedPage.length) {
            // Hiding breadcrumbs + title of the 'No Permissions' page
            $("#breadcrumbs").hide();
            $("#title-text.with-breadcrumbs").hide();

            if ($requestAccessButton.length) {
                // Trigger an event for views which have the request access button, so that we can find out
                // how many users see this page but don't use the feature
                AJS.trigger('analyticsEvent', {
                    name: 'confluence.request.access.plugin.request.access.to.page.view',
                    data: {
                        pageId: pageId,
                        requestAccessUser: requestAccessUser,
                        accessType: accessType
                    }
                });
            }
        }

        // Since the js resources load asynchronously we wait for them before enabling the button
        $requestAccessButton.prop('disabled', false);
        $requestAccessButton.removeAttr('aria-disabled');

        $requestAccessButton.click(function () {
            AJS.trigger('analyticsEvent', {
                name: 'confluence.request.access.plugin.request.access.to.page',
                data: {
                    pageId: pageId,
                    requestAccessUser: requestAccessUser,
                    accessType: accessType
                }
            });

            $requestAccessButton.attr("aria-disabled", "true");

            var loading = $(Confluence.Request.Access.loading({}));

            $requestAccessButton.replaceWith(loading);

            $.ajax({
                url: Confluence.getContextPath() + "/rest/access/latest/page/restriction/" + pageId + "/request/" + accessType,
                type: "POST",
                contentType: "application/json; charset=utf-8",
                success: function (data) {
                    if (data.users.length === 0) {
                        // Something went wrong and we received no recipients in this branch
                        // The best option is just to display an error
                        AJS.flag({
                            type: 'error',
                            title: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.not.sent.title'),
                            body: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.not.sent.message')
                        });
                        return;
                    }

                    AJS.flag({
                        type: 'success',
                        title: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.sent.title'),
                        body: AccessUtil.messageBody(data.users)
                    });
                },
                error: function (request, textStatus) {
                    AJS.flag({
                        type: 'error',
                        title: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.not.sent.title'),
                        body: AJS.I18n.getText('confluence.request.access.pagerestricted.access.request.not.sent.message')
                    });
                },
                complete: function () {
                    loading.remove();
                    Confluence.Binder.userHover();
                }
            });
        });
    });
});

