define('confluence/page-hierarchy/fetch/fetch-children', [
    'ajs',
    'confluence/page-hierarchy/transformer/children-transformer'
], function (AJS,
             transformChildren) {
    var ENDPOINT = '/rest/api/content/<pageId>/child/page?expand=children.page&limit=200';

    var cache = {};

    /**
     * Fetch the children of a piece of content. It also expands the children of the children,
     * so they can be analyzed at the same time. This is useful for the page tree preview.
     * @param {number} pageId The parent page id
     * @returns {jQuery.Deferred} with the results
     */
    function fetchChildren(pageId) {
        var deferred = AJS.$.Deferred();
        if (cache[pageId]) {
            return cache[pageId].promise();
        }
        cache[pageId] = deferred;
        AJS.$.ajax({
            url: AJS.contextPath() + ENDPOINT.replace('<pageId>', pageId),
            success: function (data) {
                deferred.resolve(transformChildren(data));
            }, error: function () {
                deferred.reject();
            }
        });

        return deferred.promise();
    }

    return fetchChildren;
});