define('confluence/page-hierarchy/action/copy-page-hierarchy-action', [
    'ajs'
], function (AJS) {
    var ENDPOINT = '/rest/page-hierarchy/copy';
    var $ = AJS.$;

    /**
     * Calls the rest end point to perform the copy action
     * @param {object} params Parameters to pass to the endpoint
     * {
     *      "copyAttachments": true,
     *      "copyPermissions": true,
     *      "copyLabels": true,
     *      "title": {
     *          prefix: "",
     *          search: "",
     *          replace: ""
     *      },
     *      "originalPageId": 3423234,
     *      "destinationPageId": 2342343,
     *  }
     * @returns {jQuery.ajax} object from the request
     */
    function copyAction(params) {
        if (!_checkParams(params)) {
            return $.Deferred().reject();
        }
        return _doCopyAction(params);
    }

    function _doCopyAction(params) {
        return $.ajax({
            type: 'POST',
            url: AJS.contextPath() + ENDPOINT,
            data: JSON.stringify($.extend(params, {atl_token: AJS.Meta.get('atl-token')})),
            contentType: 'application/json',
            dataType: 'json'
        });
    }

    function _checkParams(params) {
        return !!params;
    }

    return copyAction;
});