/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.impl.spi;

import com.atlassian.confluence.notifications.AnalyticsRenderContext;
import com.atlassian.confluence.notifications.impl.AnalyticsRenderContextManager;
import com.atlassian.confluence.notifications.impl.FakeHttpRequestInjector;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.plugin.notifications.api.template.TemplateDefinition;
import com.atlassian.plugin.notifications.api.template.TemplateType;
import com.atlassian.plugin.notifications.spi.NotificationRenderer;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Throwables;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;

public class ConfluenceNotificationRenderer
implements NotificationRenderer {
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final FakeHttpRequestInjector fakeHttpRequestInjector;
    private final AnalyticsRenderContextManager contextManager;

    public ConfluenceNotificationRenderer(SoyTemplateRenderer soyTemplateRenderer, FakeHttpRequestInjector fakeHttpRequestInjector, AnalyticsRenderContextManager contextManager) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.fakeHttpRequestInjector = fakeHttpRequestInjector;
        this.contextManager = contextManager;
    }

    public void render(TemplateDefinition template, Map<String, Object> context, Writer out) {
        this.contextManager.setContext((AnalyticsRenderContext.Context)context.get("analyticsContext"), () -> this.fakeHttpRequestInjector.withRequest(() -> {
            try {
                Object injectedData = context.get("soyInjectedData");
                Map soyInjectedData = injectedData == null || !(injectedData instanceof Map) ? Collections.emptyMap() : (Map)injectedData;
                if (TemplateType.SOY.equals((Object)template.getType())) {
                    this.soyTemplateRenderer.render((Appendable)out, template.getTemplatePackage(), template.getTemplate(), context, soyInjectedData);
                } else {
                    VelocityUtils.writeRenderedContent((Writer)out, (String)template.getTemplate(), (Map)context);
                }
            }
            catch (Throwable e) {
                Throwables.propagate((Throwable)e);
            }
            return null;
        }));
    }
}

