/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.confluence.plugins.mobile.dto.notification.RegistrationDto;
import com.atlassian.confluence.plugins.mobile.notification.PushNotificationSetting;
import com.atlassian.confluence.plugins.mobile.notification.PushNotificationStatus;
import com.atlassian.confluence.plugins.mobile.service.PushNotificationService;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/push-notification")
@Component
public class PushNotificationResource {
    private PushNotificationService pushNotificationService;

    @Autowired
    public PushNotificationResource(PushNotificationService pushNotificationService) {
        this.pushNotificationService = pushNotificationService;
    }

    @GET
    @Path(value="/status")
    public Map<String, PushNotificationStatus> getStatus() {
        return Collections.singletonMap("status", this.pushNotificationService.getStatus());
    }

    @POST
    @Path(value="/status/{status}")
    public Response getStatus(@PathParam(value="status") PushNotificationStatus status) {
        this.pushNotificationService.updateStatus(status);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/registration")
    public RegistrationDto register(RegistrationDto registrationDto) {
        return this.pushNotificationService.register(registrationDto);
    }

    @DELETE
    @Path(value="/registration/{registrationId}")
    public Response unregister(@PathParam(value="registrationId") String registrationId) {
        this.pushNotificationService.unregister(registrationId);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/setting/device/{deviceId}/app/{appName}")
    public PushNotificationSetting getSetting(@PathParam(value="deviceId") String deviceId, @PathParam(value="appName") String appName) {
        return this.pushNotificationService.getSetting(deviceId, appName);
    }

    @POST
    @Path(value="/setting/device/{deviceId}/app/{appName}")
    public PushNotificationSetting updateSetting(@PathParam(value="deviceId") String deviceId, @PathParam(value="appName") String appName, PushNotificationSetting notificationSetting) {
        return this.pushNotificationService.updateSetting(deviceId, appName, notificationSetting);
    }
}

