/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.restapi.v1_0;

import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.plugins.mobile.dto.ContentDto;
import com.atlassian.confluence.plugins.mobile.dto.SpaceDto;
import com.atlassian.confluence.plugins.mobile.model.Inclusions;
import com.atlassian.confluence.plugins.mobile.service.MobileSpaceService;
import com.atlassian.confluence.rest.api.model.ExpansionsParser;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/space")
@Component
public class MobileSpaceResource {
    private final MobileSpaceService spaceService;

    @Autowired
    public MobileSpaceResource(MobileSpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @GET
    public PageResponse<SpaceDto> getSpaces(@QueryParam(value="include") @DefaultValue(value="favourite,recent,other") String include, @QueryParam(value="expand") @DefaultValue(value="") String expand, @QueryParam(value="start") @DefaultValue(value="0") int start, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="priority") @DefaultValue(value="getAllFavourites") String priority) {
        return this.spaceService.getSpaces(priority, new Expansions(ExpansionsParser.parse((String)expand)), new Inclusions(include), (PageRequest)new SimplePageRequest(start, limit));
    }

    @GET
    @Path(value="{spaceKey}/homePage")
    public ContentDto getHomePage(@PathParam(value="spaceKey") String spaceKey, @QueryParam(value="expand") @DefaultValue(value="author") String expand) {
        return this.spaceService.getHomePage(spaceKey, new Expansions(ExpansionsParser.parse((String)expand)));
    }
}

