/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.mobile.filter;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.UserAgentUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MobileAppWebViewFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(MobileAppWebViewFilter.class);
    private static final String DUO_LOGIN_URL = "/plugins/servlet/duologin";
    private static final String DUO_LOGIN_RESOURCE = "/download/resources/com.duosecurity.confluence.plugins.duo-twofactor:resources/";
    private static final String AUTHENTICATED_COOKIE_NAME = "authenticated";
    private static final int AUTHENTICATED_COOKIE_EXPIRED_TIME = 300;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            HttpServletRequest servletRequest = (HttpServletRequest)request;
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            if (this.isMobileAppWebViewRequest(servletRequest)) {
                boolean isAuthenticated = !AuthenticatedUserThreadLocal.isAnonymousUser() && !this.isDuoLogin(servletRequest);
                Cookie cookie = new Cookie(AUTHENTICATED_COOKIE_NAME, String.valueOf(isAuthenticated));
                cookie.setMaxAge(300);
                cookie.setPath(this.getCookiePath(servletRequest));
                servletResponse.addCookie(cookie);
            }
        }
        catch (Exception e) {
            log.error("Cannot add authenticated cookie to mobile app web view request", (Throwable)e);
        }
        filterChain.doFilter(request, response);
    }

    public void destroy() {
    }

    private boolean isDuoLogin(HttpServletRequest request) {
        String url = request.getRequestURI().replace(request.getContextPath(), "");
        return url.equals(DUO_LOGIN_URL) || url.startsWith(DUO_LOGIN_RESOURCE);
    }

    private String getCookiePath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return StringUtils.isBlank((CharSequence)contextPath) ? "/" : contextPath;
    }

    private boolean isMobileAppWebViewRequest(HttpServletRequest request) {
        String userAgent = request.getHeader("USER-AGENT");
        return userAgent != null && userAgent.contains(UserAgentUtil.BrowserFamily.ATLASSIAN_MOBILE.getUserAgentString());
    }
}

