package com.atlassian.confluence.plugins.mentions.notifications;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.notifications.PayloadTransformerTemplate;
import com.atlassian.confluence.plugins.mentions.api.ConfluenceMentionEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;

public class NewContentPayloadTransformer extends PayloadTransformerTemplate<ConfluenceMentionEvent, MentionContentPayload> {
    private final UserAccessor userAccessor;

    public NewContentPayloadTransformer(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Override
    protected Maybe<MentionContentPayload> checkedCreate(ConfluenceMentionEvent event) {
        final ContentEntityObject content = event.getContent();

        final ConfluenceUser mentionedUser = userAccessor.getUserByName(event.getMentionedUserProfile().getUsername());
        final UserKey mentionedUserKey = mentionedUser != null ? mentionedUser.getKey() : null;

        final ConfluenceUser mentionAuthor = event.getMentionAuthor();
        final UserKey mentionAuthorKey = mentionAuthor != null ? mentionAuthor.getKey() : null;

        return Option.some(
                new SimpleMentionContentPayload(content.getId(),
                        content.getTypeEnum(),
                        mentionAuthorKey,
                        mentionedUserKey,
                        event.getMentionHtml()
                )
        );
    }
}
