package com.atlassian.confluence.plugins.mentions.notifications;

import com.atlassian.confluence.notifications.ConfluenceUserRole;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.RecipientsProviderTemplate;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.notifications.spi.UserRole;
import com.google.common.collect.ImmutableList;

public class MentionRecipientProvider extends RecipientsProviderTemplate<MentionContentPayload> {
    public static final UserRole USER_ROLE = new ConfluenceUserRole("com.atlassian.confluence.plugins.mentions");

    @Override
    protected Iterable<RoleRecipient> computeUserBasedRecipients(Notification<MentionContentPayload> mentionContentPayload) {
        return ImmutableList.of(
                new UserKeyRoleRecipient(USER_ROLE, mentionContentPayload.getPayload().getMentionedUserKey())
        );
    }

    @Override
    public Iterable<UserRole> getUserRoles() {
        return ImmutableList.of(USER_ROLE);
    }
}
