package com.atlassian.confluence.plugins.mentions.api;

import com.atlassian.confluence.api.model.event.notification.NotificationEnabledEvent;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.ConfluenceEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;

/**
 * An event fired when a user makes mention in Confluence content of another user.
 */
public class ConfluenceMentionEvent extends ConfluenceEvent implements NotificationEnabledEvent {

    private final ContentEntityObject content;
    private final UserProfile mentionedUserProfile;
    private final ConfluenceUser mentioningUser;
    private final String mentionHtml;

    public ConfluenceMentionEvent(final Object source,
                                  final ContentEntityObject content,
                                  final UserProfile mentionedUserProfile,
                                  final ConfluenceUser mentioningUser,
                                  final String mentionHtml) {
        super(source);
        this.content = content;
        this.mentionedUserProfile = mentionedUserProfile;
        this.mentioningUser = mentioningUser;
        this.mentionHtml = mentionHtml;
    }

    /**
     * @return the {@link ContentEntityObject} containing the mention
     */
    public ContentEntityObject getContent() {
        return content;
    }

    /**
     * @return the {@link UserProfile} of the mentioned user
     */
    public UserProfile getMentionedUserProfile() {
        return mentionedUserProfile;
    }

    /**
     * @return the {@link User} who made the mention
     */
    public User getMentioningUser() {
        return mentioningUser;
    }

    /**
     * @return the {@link ConfluenceUser} who made the mention
     */
    public ConfluenceUser getMentionAuthor() {
        return mentioningUser;
    }

    /**
     * @return an excerpt of the mention, as HTML, or {@code null} if no excerpt is available
     */
    public String getMentionHtml() {
        return mentionHtml;
    }

    @Override
    public boolean isSuppressNotifications() {
        return false;
    }
}
