package com.atlassian.confluence.plugins.mentions;

import com.atlassian.confluence.content.render.xhtml.storage.InlineTasksUtils;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.core.PluginDataSourceFactory.FilterByType;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Maybe;

import javax.activation.DataSource;

import java.util.Collections;
import java.util.Optional;

import static java.util.Collections.emptyList;

public class NotificationEmailFactoryImpl implements NotificationEmailFactory {
    private DataSourceFactory imageDataSourceFactory;

    public NotificationEmailFactoryImpl(DataSourceFactory imageDataSourceFactory) {
        this.imageDataSourceFactory = imageDataSourceFactory;
    }

    @Override
    public PreRenderedMailNotificationQueueItem create(final ContentEntityObject contentEntityObject,
                                                       final ConfluenceUser recipient,
                                                       final ConfluenceUser sender,
                                                       final String templateLocation,
                                                       final String templateName,
                                                       final String subject,
                                                       final NotificationContext context) {
        PreRenderedMailNotificationQueueItem.Builder builder = PreRenderedMailNotificationQueueItem.with(recipient, templateName, subject).andSender(sender)
                .andTemplateLocation(templateLocation).andContext(context.getMap());

        Optional<PluginDataSourceFactory> pluginFactory = imageDataSourceFactory.createForPlugin("com.atlassian.confluence.plugins.confluence-mentions-plugin");
        if (pluginFactory.isPresent()) {
            Optional<DataSource> mentionIcon = pluginFactory.get().getResourceFromModuleByName("mention-icon", "mention-icon");
            mentionIcon.ifPresent(context::addTemplateImage);
        }

        String mentionExcerpt = (String) context.get("contentHtml");
        for (DataSource resource : InlineTasksUtils.getRequiredResources(imageDataSourceFactory, mentionExcerpt)) {
            context.addTemplateImage(resource);
        }

        builder.andRelatedBodyParts(context.getTemplateImageDataSources()).andRelatedBodyParts(imagesUsedByChromeTemplate());

        return builder.render();
    }

    private Iterable<DataSource> imagesUsedByChromeTemplate() {
        return imageDataSourceFactory.createForPlugin("com.atlassian.confluence.plugins.confluence-email-resources")
                .get()
                .getResourcesFromModules("chrome-template", FilterByType.IMAGE)
                .get();
    }
}
