/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail.services;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.CachingDetailsManager;
import com.atlassian.confluence.extra.masterdetail.ExtractedDetails;
import com.atlassian.confluence.extra.masterdetail.analytics.DetailsSummaryMacroMetricsEvent;
import com.atlassian.confluence.extra.masterdetail.services.InternalPagePropertiesService;
import com.atlassian.confluence.extra.masterdetail.services.PagePropertiesExtractor;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroInstance;
import com.atlassian.confluence.plugins.pageproperties.api.model.PagePropertiesMacroReport;
import com.atlassian.confluence.plugins.pageproperties.api.model.PageProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultPagePropertiesService
implements InternalPagePropertiesService {
    private final CachingDetailsManager cachingDetailsManager;
    private final PagePropertiesExtractor pagePropertiesExtractor;

    public DefaultPagePropertiesService(CachingDetailsManager cachingDetailsManager, PagePropertiesExtractor pagePropertiesExtractor) {
        this.cachingDetailsManager = cachingDetailsManager;
        this.pagePropertiesExtractor = pagePropertiesExtractor;
    }

    @Override
    public PagePropertiesMacroReport getReportFromContent(ContentEntityObject contentEntity) {
        DetailsSummaryMacroMetricsEvent.Builder metrics = DetailsSummaryMacroMetricsEvent.builder(DetailsSummaryMacroMetricsEvent.Type.SERVICE_EXECUTION);
        ImmutableMap<String, ImmutableList<ImmutableMap<String, PageProperty>>> detailsMap = this.extractPropertiesFromContent(contentEntity, metrics);
        HashMap<String, List<PagePropertiesMacroInstance>> macroInstancesMap = new HashMap<String, List<PagePropertiesMacroInstance>>();
        detailsMap.forEach((detailsId, pageProperties) -> macroInstancesMap.put((String)detailsId, (List<PagePropertiesMacroInstance>)ImmutableList.copyOf((Collection)pageProperties.stream().map(PagePropertiesMacroInstance::new).collect(Collectors.toList()))));
        return new PagePropertiesMacroReport(macroInstancesMap);
    }

    @Override
    public List<ExtractedDetails> getDetailsFromContent(Collection<ContentEntityObject> contents, String detailsId, DetailsSummaryMacroMetricsEvent.Builder metrics) {
        ArrayList detailsList = Lists.newArrayListWithCapacity((int)contents.size());
        for (ContentEntityObject entity : contents) {
            detailsList.addAll(this.aggregatePageProperties(detailsId, (Map<String, ? extends List<ImmutableMap<String, PageProperty>>>)this.extractPropertiesFromContent(entity, metrics)).stream().map(pageProperties -> new ExtractedDetails(entity, (Map<String, PageProperty>)pageProperties)).collect(Collectors.toList()));
        }
        return detailsList;
    }

    private List<Map<String, PageProperty>> aggregatePageProperties(String detailsId, Map<String, ? extends List<ImmutableMap<String, PageProperty>>> detailsByIdMap) {
        ArrayList result = Lists.newArrayList();
        if (StringUtils.isBlank((CharSequence)detailsId)) {
            detailsByIdMap.values().forEach(value -> this.combineResults((List<ImmutableMap<String, PageProperty>>)value, result));
        } else {
            this.combineResults(detailsByIdMap.get(detailsId), result);
        }
        return result;
    }

    private void combineResults(List<ImmutableMap<String, PageProperty>> incoming, List<Map<String, PageProperty>> detailMapList) {
        if (incoming == null) {
            return;
        }
        incoming.forEach(detailMap -> {
            if (detailMapList.isEmpty() || this.hasDupeKeys(detailMapList, (Map<String, PageProperty>)detailMap)) {
                detailMapList.add(Maps.newHashMap((Map)detailMap));
            } else {
                ((Map)detailMapList.get(detailMapList.size() - 1)).putAll(detailMap);
            }
        });
    }

    private boolean hasDupeKeys(List<Map<String, PageProperty>> detailMapList, Map<String, PageProperty> details) {
        Set<String> incomingKeys = details.keySet();
        return detailMapList.stream().anyMatch(existingMap -> CollectionUtils.containsAny(existingMap.keySet(), (Collection)incomingKeys));
    }

    ImmutableMap<String, ImmutableList<ImmutableMap<String, PageProperty>>> extractPropertiesFromContent(ContentEntityObject contentEntity, DetailsSummaryMacroMetricsEvent.Builder metrics) {
        return this.cachingDetailsManager.get(contentEntity.getId(), () -> this.pagePropertiesExtractor.extractProperties(contentEntity, metrics));
    }
}

