/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.masterdetail.rest;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.masterdetail.ContentRetriever;
import com.atlassian.confluence.extra.masterdetail.DetailsSummaryBuilder;
import com.atlassian.confluence.extra.masterdetail.DetailsSummaryParameters;
import com.atlassian.confluence.extra.masterdetail.analytics.DetailsSummaryMacroMetricsEvent;
import com.atlassian.confluence.extra.masterdetail.entities.PaginatedDetailLines;
import com.atlassian.confluence.extra.masterdetail.rest.DetailsSummaryLines;
import com.atlassian.confluence.extra.masterdetail.rest.ResourceErrorType;
import com.atlassian.confluence.extra.masterdetail.rest.ResourceException;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@AnonymousAllowed
@Path(value="detailssummary")
public class DetailsSummaryResource {
    private final DetailsSummaryBuilder detailsSummaryBuilder;
    private final ContentRetriever contentRetriever;
    private final EventPublisher eventPublisher;
    private final SpaceManager spaceManager;

    public DetailsSummaryResource(EventPublisher eventPublisher, ContentRetriever contentRetriever, DetailsSummaryBuilder detailsSummaryBuilder, SpaceManager spaceManager) {
        this.eventPublisher = eventPublisher;
        this.contentRetriever = contentRetriever;
        this.detailsSummaryBuilder = detailsSummaryBuilder;
        this.spaceManager = spaceManager;
    }

    @GET
    @Path(value="lines")
    @Produces(value={"application/json"})
    public DetailsSummaryLines getDetailLines(@QueryParam(value="cql") String cql, @QueryParam(value="detailsId") String detailsId, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="reverseSort") @DefaultValue(value="false") boolean reverseSort, @QueryParam(value="spaceKey") String contextSpaceKey, @QueryParam(value="contentId") ContentId contentId, @QueryParam(value="pageSize") @DefaultValue(value="30") int pageSize, @QueryParam(value="pageIndex") @DefaultValue(value="0") int currentPage, @QueryParam(value="countComments") @DefaultValue(value="false") boolean countComments, @QueryParam(value="countLikes") @DefaultValue(value="false") boolean countLikes, @QueryParam(value="headings") String headings) {
        if (StringUtils.isEmpty((CharSequence)contextSpaceKey)) {
            throw new ResourceException("'spaceKey' parameter is required", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_MISSING, (Object)"spaceKey");
        }
        if (pageSize <= 0) {
            throw new ResourceException("Requested page size is not valid", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_INVALID, (Object)"pageSize");
        }
        if (currentPage < 0) {
            throw new ResourceException("Requested page index is not valid", Response.Status.BAD_REQUEST, ResourceErrorType.PARAMETER_INVALID, (Object)"pageIndex");
        }
        try {
            DetailsSummaryMacroMetricsEvent.Builder metrics = DetailsSummaryMacroMetricsEvent.builder(DetailsSummaryMacroMetricsEvent.Type.REST_RESOURCE);
            SearchContext searchContext = SearchContext.builder().spaceKey(contextSpaceKey).contentId(contentId).build();
            List<ContentEntityObject> content = this.contentRetriever.getContentWithMetaData(cql, reverseSort, searchContext, metrics);
            DetailsSummaryParameters summaryParams = new DetailsSummaryParameters().setPageSize(pageSize).setCurrentPage(currentPage).setCountComments(countComments).setCountLikes(countLikes).setHeadingsString(headings).setSortBy(sortBy).setReverseSort(reverseSort).setContent(content).setId(detailsId);
            PaginatedDetailLines paginatedDetailLines = this.detailsSummaryBuilder.getPaginatedDetailLines(summaryParams, true, metrics, ConversionContextOutputType.DISPLAY.value());
            this.eventPublisher.publish((Object)metrics.build());
            return new DetailsSummaryLines(summaryParams.getCurrentPage(), summaryParams.getTotalPages(), paginatedDetailLines.getRenderedHeadings(), paginatedDetailLines.getDetailLines(), paginatedDetailLines.isAsyncRenderSafe());
        }
        catch (MacroExecutionException e) {
            throw new ResourceException(e, Response.Status.INTERNAL_SERVER_ERROR, ResourceErrorType.RENDERING_MACRO);
        }
    }
}

