(function($){
    "use strict";

    AJS.$(function ($) {
        $("#qunit-fixture").append("<div id='task-container-test'>");
    });


    var $taskContainer,
        labelMap = {
            'blank.assignedToMe-complete.title': '.assignedToMe-complete',
            'blank.assignedToMe-complete.desc': '.assignedToMe-complete',
            'blank.assignedToMe-incomplete.title': '.assignedToMe-incomplete',
            'blank.assignedToMe-incomplete.desc': '.assignedToMe-incomplete',
            'blank.createdByMe-complete.title': '.createdByMe-complete',
            'blank.createdByMe-complete.desc': '.createdByMe-complete',
            'blank.createdByMe-incomplete.title': '.createdByMe-incomplete',
            'blank.createdByMe-incomplete.desc': '.createdByMe-incomplete'
        },
        options = {
            setup: function () {
                $taskContainer = $('#task-container-test');
            },
            teardown: function() {
                $taskContainer.empty();
            }
        };

    AJS.test.require("com.atlassian.confluence.plugins.confluence-inline-tasks:my-tasks-blank-exp-resources", AJS.$.noop);

    module("test method 'renderBlankExperiences'", options);

    test("test assignedToMe and complete", function() {
        Confluence.InlineTasks.MyTasks.renderBlankExperiences("assignedToMe", "complete", $taskContainer, labelMap);
        ok($taskContainer.find(labelMap['blank.assignedToMe-complete.title']).length > 0);
    });

    test("test assignedToMe and incomplete", function() {
        Confluence.InlineTasks.MyTasks.renderBlankExperiences("assignedToMe", "incomplete", $taskContainer, labelMap);
        ok($taskContainer.find(labelMap['blank.assignedToMe-incomplete.title']).length > 0);
    });

    test("test createdByMe and complete", function() {
        Confluence.InlineTasks.MyTasks.renderBlankExperiences("createdByMe", "complete", $taskContainer, labelMap);
        ok($taskContainer.find(labelMap['blank.createdByMe-complete.title']).length > 0);
    });

    test("test createdByMe and incomplete", function() {
        Confluence.InlineTasks.MyTasks.renderBlankExperiences("createdByMe", "incomplete", $taskContainer, labelMap);
        ok($taskContainer.find(labelMap['blank.createdByMe-incomplete.title']).length > 0);
    });

}(AJS.$));