/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.service;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.ao.AOInlineTask;
import com.atlassian.confluence.plugins.tasklist.service.LimitedRequestImpl;
import com.atlassian.confluence.plugins.tasklist.service.util.TaskContentUtils;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class TaskPaginationService {
    private final ConfluenceUser confluenceUser;
    private final PermissionManager permissionManager;
    private final PageManager pageManager;
    private final PaginationService paginationService;
    private final UserAccessor userAccessor;
    private static final int MAX_LIMIT = 5000;

    public TaskPaginationService(ConfluenceUser confluenceUser, PermissionManager permissionManager, PageManager pageManager, PaginationService paginationService, UserAccessor userAccessor) {
        this.confluenceUser = confluenceUser;
        this.permissionManager = permissionManager;
        this.pageManager = pageManager;
        this.paginationService = paginationService;
        this.userAccessor = userAccessor;
    }

    public PageResponse<Task> filter(final List<AOInlineTask> inlineTasks, PageRequest pageRequest) {
        LimitedRequest limitedRequest = LimitedRequestImpl.create(pageRequest, 5000);
        if (CollectionUtils.isEmpty(inlineTasks)) {
            return PageResponseImpl.from(new ArrayList(), (boolean)false).pageRequest(limitedRequest).build();
        }
        PageResponse tasks = this.paginationService.doPaginationRequest(limitedRequest, (PaginationBatch)new PaginationBatch<AOInlineTask>(){

            public PageResponse<AOInlineTask> apply(LimitedRequest limitedRequest) {
                boolean hasMore = true;
                int start = limitedRequest.getStart();
                int limit = limitedRequest.getLimit();
                int endIndex = Math.min(start + limit + 1, inlineTasks.size());
                List input = inlineTasks.subList(limitedRequest.getStart(), endIndex);
                Iterable pageIds = Iterables.transform(input, (Function)new Function<AOInlineTask, Long>(){

                    public Long apply(AOInlineTask task) {
                        return task.getContentId();
                    }
                });
                List pages = TaskPaginationService.this.pageManager.getAbstractPages((Iterable)ImmutableSet.copyOf((Iterable)pageIds));
                List canView = TaskPaginationService.this.permissionManager.getPermittedEntitiesNoExemptions((User)TaskPaginationService.this.confluenceUser, Permission.VIEW, pages);
                ImmutableList viewablePageIds = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)canView, (Function)new Function<AbstractPage, Long>(){

                    public Long apply(AbstractPage input) {
                        return input.getId();
                    }
                }));
                Iterable results = Iterables.filter(input, (Predicate)new Predicate<AOInlineTask>((List)viewablePageIds){
                    final /* synthetic */ List val$viewablePageIds;
                    {
                        this.val$viewablePageIds = list;
                    }

                    public boolean apply(AOInlineTask input) {
                        return this.val$viewablePageIds.contains(input.getContentId()) && !TaskContentUtils.isBlankContent(input.getBody());
                    }
                });
                if (endIndex >= inlineTasks.size()) {
                    hasMore = false;
                }
                return PageResponseImpl.from((Iterable)results, (boolean)hasMore).pageRequest(limitedRequest).build();
            }
        }, (Function)new Function<AOInlineTask, Task>(){

            public Task apply(AOInlineTask ao) {
                return new Task.Builder().withGlobalId(ao.getGlobalId()).withId(ao.getId()).withContentId(ao.getContentId()).withStatus(ao.getTaskStatus()).withBody(ao.getBody()).withCreator(TaskPaginationService.this.getUsername(ao.getCreatorUserKey())).withAssignee(TaskPaginationService.this.getUsername(ao.getAssigneeUserKey())).withCreateDate(ao.getCreateDate()).withDueDate(ao.getDueDate()).withUpdateDate(ao.getUpdateDate()).withCompleteDate(ao.getCompleteDate()).withCompleteUser(TaskPaginationService.this.getUsername(ao.getCompleteUserKey())).build();
            }
        });
        return tasks;
    }

    private String getUsername(String userKey) {
        if (userKey == null) {
            return null;
        }
        ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(userKey));
        return user == null ? null : user.getName();
    }
}

