/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.notification;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.core.PluginDataSourceFactory;
import com.atlassian.confluence.internal.ContentEntityManagerInternal;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.TaskModfication;
import com.atlassian.confluence.plugins.tasklist.TaskStatus;
import com.atlassian.confluence.plugins.tasklist.notification.NotificationDataService;
import com.atlassian.confluence.plugins.tasklist.notification.NotificationEmailFactory;
import com.atlassian.confluence.plugins.tasklist.notification.NotificationService;
import com.atlassian.confluence.plugins.tasklist.notification.TaskRenderService;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.fugue.Maybe;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserResolutionException;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationServiceImpl
implements NotificationService,
TaskRenderService {
    private static final Logger log = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private static final String SOY_RESOURCES = "com.atlassian.confluence.plugins.confluence-inline-tasks:email-resources";
    private static final String TASK_TEMPLATE = "Confluence.Templates.InlineTasks.Notifications.inlineTask.soy";
    private static final String IMAGE_RESOURCES_KEY = "inline-task-mail-resources";
    private static final MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
    private final MultiQueueTaskManager taskManager;
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final I18NBeanFactory i18NBeanFactory;
    private final LocaleManager localeManager;
    private final DataSourceFactory imageDataSourceFactory;
    private final NotificationEmailFactory notificationEmailFactory;
    private final NotificationDataService notificationDataService;
    private final XhtmlContent xhtmlContent;
    private final ContentEntityManager contentEntityManager;
    private final TransactionTemplate transactionTemplate;
    private final PluginDataSourceFactory pluginDataSourceFactory;

    @Autowired
    public NotificationServiceImpl(MultiQueueTaskManager taskManager, UserManager userManager, UserAccessor userAccessor, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager, DataSourceFactory imageDataSourceFactory, NotificationEmailFactory notificationEmailFactory, NotificationDataService notificationDataService, XhtmlContent xhtmlContent, ContentEntityManagerInternal contentEntityManager, TransactionTemplate transactionTemplate) {
        this.taskManager = taskManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
        this.imageDataSourceFactory = imageDataSourceFactory;
        this.notificationEmailFactory = notificationEmailFactory;
        this.notificationDataService = notificationDataService;
        this.xhtmlContent = xhtmlContent;
        this.contentEntityManager = contentEntityManager;
        this.transactionTemplate = transactionTemplate;
        Maybe pluginFactory = imageDataSourceFactory.forPlugin("com.atlassian.confluence.plugins.confluence-inline-tasks");
        this.pluginDataSourceFactory = (PluginDataSourceFactory)pluginFactory.getOrNull();
    }

    @Override
    public void sendInlineTasksEmail(ListMultimap<String, TaskModfication> tasks, ContentEntityObject content) {
        if (tasks.isEmpty()) {
            return;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        NotificationData notificationData = this.notificationDataService.prepareDecorationContext(user, content);
        for (String recipientUsername : tasks.keySet()) {
            if (!StringUtils.isNotBlank((String)recipientUsername)) continue;
            List updates = tasks.get((Object)recipientUsername);
            this.sendInlineTaskUpdates(recipientUsername, user, updates, content, notificationData);
        }
    }

    private void sendInlineTaskUpdates(String recipientUserName, ConfluenceUser author, List<TaskModfication> updates, ContentEntityObject contentEntityObject, NotificationData notificationData) throws UserResolutionException {
        if (author != null && recipientUserName.equals(author.getName())) {
            return;
        }
        Principal principal = this.userManager.resolve(recipientUserName);
        I18NBean userI18NBean = principal instanceof ConfluenceUser ? this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)((ConfluenceUser)principal))) : this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale(null));
        String fullName = author != null ? author.getFullName() : userI18NBean.getText("anonymous.name");
        String subject = Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.ASSIGNED)).size() > 0 ? userI18NBean.getText("inline-tasks-update.mail.subject.assigned", new Object[]{fullName, contentEntityObject.getDisplayTitle()}) : userI18NBean.getText("inline-tasks-update.mail.subject.updated", new Object[]{fullName, contentEntityObject.getDisplayTitle()});
        ConfluenceUser mentionedUser = this.userAccessor.getUserByName(recipientUserName);
        if (mentionedUser == null || mentionedUser.getEmail() == null || mentionedUser.getEmail().trim().length() == 0) {
            return;
        }
        NotificationContext context = notificationData.getCommonContext();
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskStatus.CHECKED)).size() > 0) {
            context.addTemplateImage((DataSource)this.pluginDataSourceFactory.resourceFromModuleByName(IMAGE_RESOURCES_KEY, "inline-task-checked-icon").get());
        }
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskStatus.UNCHECKED)).size() > 0) {
            context.addTemplateImage((DataSource)this.pluginDataSourceFactory.resourceFromModuleByName(IMAGE_RESOURCES_KEY, "inline-task-unchecked-icon").get());
        }
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)contentEntityObject.toPageContext());
        boolean includeCalendarIcon = Boolean.FALSE;
        for (TaskModfication taskModification : updates) {
            Task curTask = taskModification.getTask();
            String taskViewHtml = this.getTaskView(curTask, conversionContext);
            taskModification.setHtmlContent(taskViewHtml);
            if (curTask.getDueDate() == null) continue;
            includeCalendarIcon = Boolean.TRUE;
        }
        context.addTemplateImage((DataSource)this.pluginDataSourceFactory.resourceFromModuleByName(IMAGE_RESOURCES_KEY, "inline-task-action-icon").get());
        if (includeCalendarIcon) {
            context.addTemplateImage((DataSource)this.pluginDataSourceFactory.resourceFromModuleByName(IMAGE_RESOURCES_KEY, "inline-task-calendar-icon").get());
        }
        ArrayList<Collection> categorizedTasks = new ArrayList<Collection>();
        String emailHeaderActioni18nString = "";
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.ASSIGNED)).size() > 0) {
            categorizedTasks.add(Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.ASSIGNED)));
            emailHeaderActioni18nString = "tasks.mail.templates.assigned.task";
        }
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.UNASSIGNED)).size() > 0) {
            categorizedTasks.add(Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.UNASSIGNED)));
            emailHeaderActioni18nString = "tasks.mail.templates.unassigned.task";
        }
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.COMPLETE)).size() > 0) {
            categorizedTasks.add(Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.COMPLETE)));
            emailHeaderActioni18nString = "tasks.mail.templates.marked.complete";
        }
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.IN_COMPLETE)).size() > 0) {
            categorizedTasks.add(Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.IN_COMPLETE)));
            emailHeaderActioni18nString = "tasks.mail.templates.marked.incomplete";
        }
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.DELETED)).size() > 0) {
            categorizedTasks.add(Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.DELETED)));
            emailHeaderActioni18nString = "tasks.mail.templates.deleted";
        }
        if (Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.REWORDED)).size() > 0) {
            categorizedTasks.add(Collections2.filter(updates, NotificationServiceImpl.with(TaskModfication.Operation.REWORDED)));
            emailHeaderActioni18nString = "tasks.mail.templates.reworded";
        }
        if (categorizedTasks.size() > 1) {
            emailHeaderActioni18nString = "tasks.mail.templates.multiple.actions";
        }
        context.put("actions", this.getActionLinks(contentEntityObject));
        context.put("headerActionString", (Object)emailHeaderActioni18nString);
        context.put("categorizedTasks", categorizedTasks);
        context.put("numberOfTasks", (Object)updates.size());
        String templateLocation = SOY_RESOURCES;
        String templateName = TASK_TEMPLATE;
        this.sendEmail(contentEntityObject, mentionedUser, author, templateLocation, templateName, subject, context);
    }

    private static Predicate<TaskModfication> with(final @Nonnull TaskModfication.Operation operation) {
        return new Predicate<TaskModfication>(){

            public boolean apply(TaskModfication taskUpdate) {
                return taskUpdate.getTaskOperation() == operation;
            }
        };
    }

    private static Predicate<TaskModfication> with(final @Nonnull TaskStatus status) {
        return new Predicate<TaskModfication>(){

            public boolean apply(TaskModfication taskUpdate) {
                return taskUpdate.getTask().getStatus() == status;
            }
        };
    }

    private Function<TaskModfication, TaskModfication> renderTask(final DefaultConversionContext conversionContext) {
        return new Function<TaskModfication, TaskModfication>(){

            public TaskModfication apply(TaskModfication taskModification) {
                taskModification.setHtmlContent(NotificationServiceImpl.this.getTaskView(taskModification.getTask(), conversionContext));
                return taskModification;
            }
        };
    }

    private void sendEmail(ContentEntityObject contentEntityObject, ConfluenceUser recipient, ConfluenceUser sender, String templateLocation, String templateName, String subject, NotificationContext context) {
        PreRenderedMailNotificationQueueItem mail = this.notificationEmailFactory.create(contentEntityObject, recipient, sender, templateLocation, templateName, subject, context);
        this.taskManager.addTask("mail", (com.atlassian.core.task.Task)mail);
    }

    private List<TasksNotificationLink> getActionLinks(ContentEntityObject ceo) {
        ArrayList<TasksNotificationLink> actionLinks = new ArrayList<TasksNotificationLink>();
        actionLinks.add(new TasksNotificationLink("inline-task-action-icon", "tasks.mail.templates.view.all.my.tasks", "/plugins/inlinetasks/mytasks.action?source=email"));
        actionLinks.add(new TasksNotificationLink(ceo.getType() + "-icon", ceo.getDisplayTitle(), ceo.getUrlPath()));
        return actionLinks;
    }

    @Override
    public Iterable<TaskModfication> renderTasksOnPage(final Iterable<TaskModfication> tasks, final Content content) {
        return (Iterable)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Iterable<TaskModfication>>(){

            public Iterable<TaskModfication> doInTransaction() {
                PageContext contentEntity = NotificationServiceImpl.this.contentEntityManager.getById(content.getId().asLong()).toPageContext();
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)contentEntity);
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)tasks, (Function)NotificationServiceImpl.this.renderTask(conversionContext)));
            }
        });
    }

    private String getTaskView(Task task, DefaultConversionContext conversionContext) {
        String html = null;
        try {
            html = this.xhtmlContent.convertStorageToView(task.getBody(), (ConversionContext)conversionContext);
            Document doc = Jsoup.parse((String)html);
            doc.getElementsByTag("br").remove();
            html = doc.html();
        }
        catch (XMLStreamException e) {
            log.error("Unable to convert task from storage to view format for email.", (Throwable)e);
            return "";
        }
        catch (XhtmlException e) {
            log.error("Unable to convert task from storage to view format for email.", (Throwable)e);
            return "";
        }
        return html;
    }

    static {
        try {
            fileTypeMap.addMimeTypes(IOUtils.toString((InputStream)BootstrapManager.class.getResourceAsStream("/mime.types")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mime types");
        }
    }

    public class TasksNotificationLink {
        private String icon;
        private String text;
        private String href;

        public TasksNotificationLink(String icon, String text, String href) {
            this.icon = icon;
            this.text = text;
            this.href = href;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getText() {
            return this.text;
        }

        public String getHref() {
            return this.href;
        }
    }
}

