/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.listener;

import com.atlassian.confluence.mail.notification.listeners.NotificationApiDarkFeature;
import com.atlassian.confluence.plugins.tasklist.event.SendTaskEmailEvent;
import com.atlassian.confluence.plugins.tasklist.notification.NotificationService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InlineTasksAssignmentEventListener
implements DisposableBean {
    private final NotificationService notificationService;
    private final EventPublisher eventPublisher;

    @Autowired
    public InlineTasksAssignmentEventListener(EventPublisher eventPublisher, NotificationService notificationService) {
        this.eventPublisher = eventPublisher;
        this.notificationService = notificationService;
        eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void tasksModified(SendTaskEmailEvent event) {
        if (!NotificationApiDarkFeature.NotificationPluginApi.isEnabled((Object)event)) {
            this.notificationService.sendInlineTasksEmail(event.getTasks(), event.getContent());
        }
    }
}

