/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.Task;
import com.atlassian.confluence.plugins.tasklist.service.InlineTaskService;
import com.atlassian.confluence.plugins.tasklist.transformer.InlineTaskFinder;
import com.atlassian.confluence.plugins.tasklist.upgradetask.StorageToAoMigrationLatch;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageToAoMigrationTaskExtractor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StorageToAoMigrationTaskExtractor.class);
    private static final int BATCH_SIZE = 10;
    private static final int MAX_VERSIONS_TO_CHECK = 500;
    private final BlockingQueue<ContentEntityObject> pageQueue;
    private final BlockingQueue<Task> tasksMigrationQueue;
    private final InlineTaskFinder inlineTaskFinder;
    private final InlineTaskService inlineTaskService;
    private final TransactionTemplate transactionTemplate;
    private final PluginHibernateSessionFactory hibernateSessionFactory;
    private final PageManager pageManager;
    private final boolean checkForDuplicates;
    private final StorageToAoMigrationLatch latch;

    public StorageToAoMigrationTaskExtractor(BlockingQueue<ContentEntityObject> pageQueue, BlockingQueue<Task> tasksMigrationQueue, InlineTaskFinder inlineTaskFinder, InlineTaskService inlineTaskService, TransactionTemplate transactionTemplate, PluginHibernateSessionFactory hibernateSessionFactory, PageManager pageManager, boolean checkForDuplicates, StorageToAoMigrationLatch latch) {
        this.pageQueue = pageQueue;
        this.tasksMigrationQueue = tasksMigrationQueue;
        this.inlineTaskFinder = inlineTaskFinder;
        this.inlineTaskService = inlineTaskService;
        this.transactionTemplate = transactionTemplate;
        this.hibernateSessionFactory = hibernateSessionFactory;
        this.pageManager = pageManager;
        this.checkForDuplicates = checkForDuplicates;
        this.latch = latch;
    }

    @Override
    public void run() {
        try {
            ContentEntityObject lastCeoProcessed;
            final AtomicReference interrupted = new AtomicReference();
            while ((lastCeoProcessed = (ContentEntityObject)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<ContentEntityObject>(){

                public ContentEntityObject doInTransaction() {
                    Session session = StorageToAoMigrationTaskExtractor.this.hibernateSessionFactory.getSession();
                    ContentEntityObject ceo = null;
                    for (int i = 0; i < 10; ++i) {
                        try {
                            ceo = StorageToAoMigrationTaskExtractor.this.getTaskFromPageQueue();
                            if (ceo == null) break;
                            session.refresh((Object)ceo);
                            Collection<Task> tasksOnPage = StorageToAoMigrationTaskExtractor.this.inlineTaskFinder.extractTasks(ceo.getId(), ceo.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)ceo.toPageContext())).values();
                            final Collection migratedTaskIds = StorageToAoMigrationTaskExtractor.this.getMigratedTaskIds(ceo, tasksOnPage);
                            Iterable tasksToMigrate = Iterables.filter(tasksOnPage, (Predicate)new Predicate<Task>(){

                                public boolean apply(Task task) {
                                    return !migratedTaskIds.contains(task.getId());
                                }
                            });
                            Iterable tasksWithCreator = StorageToAoMigrationTaskExtractor.this.addCreatorInformation(tasksToMigrate, ceo);
                            for (Task task : tasksWithCreator) {
                                StorageToAoMigrationTaskExtractor.this.tasksMigrationQueue.put(task);
                            }
                            continue;
                        }
                        catch (InterruptedException e) {
                            interrupted.set(e);
                            return null;
                        }
                        catch (HibernateException e) {
                            log.error("Failed to extract tasks from CEO. Failed to refresh CEO {}", (Object)ceo);
                        }
                    }
                    return ceo;
                }
            })) != null && interrupted.get() == null) {
            }
            if (interrupted.get() != null) {
                log.warn("Task extractor was interrupted. Aborting.");
                return;
            }
            log.debug("Finished creating task objects from pages.");
        }
        finally {
            this.latch.taskExtractorDone();
        }
    }

    private Iterable<Task> addCreatorInformation(Iterable<Task> tasks, ContentEntityObject ceo) {
        return Iterables.transform(tasks, task -> {
            String creator = this.getAuthorFromCeo(ceo);
            Date creationDate = this.getCreationDateFromCeo(ceo);
            if (ceo.getVersion() != 1) {
                List history = this.pageManager.getPreviousVersionsOfPageWithTaskId(ceo.getId(), task.getId(), 500);
                ContentEntityObject previousOne = null;
                for (ContentEntityObject page : history) {
                    if (previousOne != null && previousOne.getVersion() != page.getVersion() + 1) break;
                    previousOne = page;
                }
                if (previousOne != null) {
                    if (!history.isEmpty() && ((ContentEntityObject)history.get(history.size() - 1)).getId() == previousOne.getId() && history.size() >= 500) {
                        log.warn("Page {} may have over {} versions for task id {}.The creator information was not extracted.", new Object[]{ceo, 500, task.getId()});
                        creator = null;
                        creationDate = null;
                    } else {
                        creator = this.getAuthorFromCeo(previousOne);
                        creationDate = this.getCreationDateFromCeo(previousOne);
                    }
                }
            }
            return new Task.Builder((Task)task).withCreator(creator).withCreateDate(creationDate).build();
        });
    }

    private Date getCreationDateFromCeo(ContentEntityObject ceo) {
        if (ceo.getLastModificationDate() != null) {
            return ceo.getLastModificationDate();
        }
        return ceo.getCreationDate();
    }

    private String getAuthorFromCeo(ContentEntityObject ceo) {
        if (ceo.getLastModifier() != null) {
            return ceo.getLastModifier().getName();
        }
        if (ceo.getCreator() != null) {
            return ceo.getCreator().getName();
        }
        return null;
    }

    private Collection<Long> getMigratedTaskIds(ContentEntityObject ceo, Collection<Task> tasks) {
        int numTasksInPage = tasks.size();
        if (numTasksInPage == 0 || !this.checkForDuplicates) {
            return Collections.emptySet();
        }
        log.debug("Migrating {} tasks in {}", (Object)numTasksInPage, (Object)ceo);
        return this.inlineTaskService.findTaskIdsByContentId(ceo.getId());
    }

    private ContentEntityObject getTaskFromPageQueue() throws InterruptedException {
        ContentEntityObject task;
        while ((task = this.pageQueue.poll(10L, TimeUnit.MILLISECONDS)) == null && !this.latch.isPageFindComplete()) {
        }
        return task;
    }

    static {
        LogManager.getLogger(StorageToAoMigrationTaskExtractor.class).setLevel(Level.INFO);
    }
}

