/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.tasklist.upgradetask;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.tasklist.ao.AOInlineTask;
import com.atlassian.confluence.plugins.tasklist.transformer.InlineTaskFinder;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.ao.DatabaseProvider;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteDuplicateTasksUpgradeTask
implements PluginUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteDuplicateTasksUpgradeTask.class);
    private static final Class<AOInlineTask> AO_TASK_TYPE = AOInlineTask.class;
    private static final String FIND_PAGE_WITH_TASKS_SQL = "select distinct ${contentId} from ${inlineTasksTable}";
    private static final String DELETE_TASKS_ON_PAGE_SQL = "delete from ${inlineTasksTable} where ${contentId} = ?";
    private static final String DELETE_TASKS_ON_PAGE_CONDITION = " and ${id} not in ";
    private static final String DELETE_ORPHANED_TASKS_SQL = "delete from ${inlineTasksTable} where ${globalId} in (select a.${globalId} from ${inlineTasksTable} a left outer join CONTENT b on (a.${contentId} = b.CONTENTID) WHERE b.PREVVER is null and b.CONTENTID is null)";
    private static final String DELETE_ORPHANED_TASKS_MYSQL = "delete a from ${inlineTasksTable} a left outer join CONTENT b on (a.${contentId} = b.CONTENTID) WHERE b.PREVVER is null and b.CONTENTID is null";
    private static final String SQL = "delete from ${inlineTasksTable} where ${globalId} in (select t1.${globalId} from ${inlineTasksTable} t1, ${inlineTasksTable} t2 where t1.${id} = t2.${id} and t1.${contentId} = t2.${contentId} and ((t1.${updateDate} is null and t2.${updateDate} is null and t1.${globalId} < t2.${globalId}) or (t1.${updateDate} is null and t2.${updateDate} is not null) or  (t1.${updateDate} is not null and t2.${updateDate} is not null and t1.${updateDate} < t2.${updateDate})))";
    private static final String MYSQL = "delete t1 from ${inlineTasksTable} t1, ${inlineTasksTable} t2 where t1.${id} = t2.${id} and t1.${contentId} = t2.${contentId} and ((t1.${updateDate} is null and t2.${updateDate} is null and t1.${globalId} < t2.${globalId}) or (t1.${updateDate} is null and t2.${updateDate} is not null) or  (t1.${updateDate} is not null and t2.${updateDate} is not null and t1.${updateDate} < t2.${updateDate})) ";
    private final ActiveObjects ao;
    private final PageManager pageManager;
    private final InlineTaskFinder finder;

    @Autowired
    public DeleteDuplicateTasksUpgradeTask(ActiveObjects ao, PageManager pageManager, InlineTaskFinder finder) {
        this.ao = ao;
        this.pageManager = pageManager;
        this.finder = finder;
    }

    public int getBuildNumber() {
        return 3;
    }

    public String getShortDescription() {
        return "Remove duplicated tasks inserted by a bug, see CONF-33886";
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-inline-tasks";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Message> doUpgrade() throws Exception {
        this.ao.moduleMetaData().awaitInitialization();
        AOInlineTask[] aoInlineTask = (AOInlineTask[])this.ao.find(AO_TASK_TYPE, Query.select().limit(1));
        if (aoInlineTask.length == 0) {
            return Collections.emptyList();
        }
        DatabaseProvider provider = aoInlineTask[0].getEntityManager().getProvider();
        Connection connection = null;
        ImmutableMap valuesMap = ImmutableMap.of((Object)"globalId", (Object)provider.quote("GLOBAL_ID"), (Object)"id", (Object)provider.quote("ID"), (Object)"contentId", (Object)provider.quote("CONTENT_ID"), (Object)"inlineTasksTable", (Object)provider.quote("AO_BAF3AA_AOINLINE_TASK"), (Object)"updateDate", (Object)provider.quote("UPDATE_DATE"));
        StrSubstitutor sub = new StrSubstitutor((Map)valuesMap);
        try {
            int deletedTasks = 0;
            connection = provider.getConnection();
            boolean isMySql = StringUtils.equalsIgnoreCase((String)"MySQL", (String)connection.getMetaData().getDatabaseProductName());
            List<AbstractPage> pages = this.getPagesWithTasks(connection, sub);
            deletedTasks += this.deleteDeletedTasks(connection, sub, pages);
            deletedTasks += this.deleteDuplicateTasks(connection, sub, isMySql);
            if ((deletedTasks += this.deleteOrphanedTasks(connection, sub, isMySql)) > 0) {
                LOG.warn("{} duplicate task(s) were found and deleted", (Object)deletedTasks);
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteDuplicateTasks(Connection connection, StrSubstitutor sub, boolean isMySql) throws SQLException {
        try (Statement stmt = null;){
            stmt = connection.prepareStatement(sub.replace(isMySql ? MYSQL : SQL));
            int deletedTasks = stmt.executeUpdate();
            LOG.debug("deleted {} of duplicated tasks", (Object)deletedTasks);
            int n = deletedTasks;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOrphanedTasks(Connection connection, StrSubstitutor sub, boolean isMySql) throws SQLException {
        try (Statement stmt = null;){
            stmt = connection.prepareStatement(sub.replace(isMySql ? DELETE_ORPHANED_TASKS_MYSQL : DELETE_ORPHANED_TASKS_SQL));
            int deletedTasks = stmt.executeUpdate();
            LOG.debug("deleted {} of orphaned tasks", (Object)deletedTasks);
            int n = deletedTasks;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteDeletedTasks(Connection connection, StrSubstitutor sub, List<AbstractPage> pages) throws SQLException {
        int deletedTasks = 0;
        try (Statement stmt = null;){
            for (AbstractPage page : pages) {
                int index = 1;
                Set<Long> taskIds = this.finder.findTasksInContent(page.getId(), page.getBodyAsString(), (ConversionContext)new DefaultConversionContext((RenderContext)page.toPageContext())).keySet();
                int numberOfTasks = taskIds.size();
                if (numberOfTasks > 1000) {
                    LOG.warn("Page {} has over 1000 tasks. Task count is {}", (Object)page, (Object)numberOfTasks);
                    continue;
                }
                String deleteTaskSql = numberOfTasks == 0 ? sub.replace(DELETE_TASKS_ON_PAGE_SQL) : sub.replace("delete from ${inlineTasksTable} where ${contentId} = ? and ${id} not in ") + this.buildQuestionMarkString(numberOfTasks);
                stmt = connection.prepareStatement(sub.replace(deleteTaskSql));
                stmt.setLong(index++, page.getId());
                for (Long taskId : taskIds) {
                    stmt.setLong(index++, taskId);
                }
                int deleted = stmt.executeUpdate();
                LOG.debug("deleted {} of *deleted* tasks from page: {} with id: {}", new Object[]{deleted, page.getTitle(), page.getId()});
                deletedTasks += deleted;
                stmt.close();
            }
        }
        return deletedTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbstractPage> getPagesWithTasks(Connection connection, StrSubstitutor sub) throws SQLException {
        ArrayList pageIds = Lists.newArrayList();
        try (PreparedStatement stmt = null;){
            stmt = connection.prepareStatement(sub.replace(FIND_PAGE_WITH_TASKS_SQL));
            ResultSet resultSet = stmt.executeQuery();
            while (resultSet.next()) {
                pageIds.add(resultSet.getLong(1));
            }
        }
        return this.pageManager.getAbstractPages((Iterable)pageIds);
    }

    private String buildQuestionMarkString(int length) {
        return "(" + Joiner.on((String)",").join(Collections.nCopies(length, "?")) + ")";
    }
}

