/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.soy;

import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleJsonSerializeFunction
implements SoyServerFunction<String> {
    private static final Logger log = LoggerFactory.getLogger(SimpleJsonSerializeFunction.class);
    private static final Set<Integer> VALID_ARG_SIZES = ImmutableSet.of((Object)1);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public String apply(Object ... args) {
        Object object = args[0];
        try {
            return OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (IOException e) {
            log.error("Error serializing " + object, (Throwable)e);
            return "";
        }
    }

    public String getName() {
        return "simpleJsonSerialize";
    }

    public Set<Integer> validArgSizes() {
        return VALID_ARG_SIZES;
    }
}

