/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.impl;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.NotificationMessageBuilder;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.api.notifications.SpaceToRoomNotification;
import com.atlassian.confluence.plugins.hipchat.util.LinkHelper;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import io.atlassian.fugue.Option;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNotificationMessageBuilder
implements NotificationMessageBuilder {
    private static final String DEFAULT_AVATAR_PATH = "/download/resources/com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin/images/avatar.png";
    private static final Logger logger = LoggerFactory.getLogger(DefaultNotificationMessageBuilder.class);
    private final ApplicationProperties applicationProperties;
    private final I18nResolver i18nResolver;
    private final PersonalInformationManager personalInformationManager;
    private final UserAccessor userAccessor;

    public DefaultNotificationMessageBuilder(ApplicationProperties applicationProperties, I18nResolver i18nResolver, PersonalInformationManager personalInformationManager, UserAccessor userAccessor) {
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.personalInformationManager = personalInformationManager;
        this.userAccessor = userAccessor;
    }

    @Override
    public String buildMessage(SpaceToRoomNotification notification, Object event) {
        return this.i18nResolver.getText(notification.getMessageKey(event), new Serializable[]{notification.getIcon(event).render(), notification.getLink(event), this.userLinkHtml(notification.getUser(event))});
    }

    @Override
    public Option<String> buildActivityText(String activityKey, SpaceToRoomNotification notification, Object event) {
        return Option.some((Object)this.i18nResolver.getText(activityKey, new Serializable[]{this.userLinkHtml(notification.getUser(event)), notification.getLink(event)}));
    }

    @Override
    public String getLabel(String i18nKey) {
        return this.i18nResolver.getText(i18nKey);
    }

    @Override
    public Option<URL> getUserAvatar(UserKey userKey) {
        return this.getDefaultUserAvatar();
    }

    @Override
    public Option<URL> getDefaultUserAvatar() {
        try {
            return Option.some((Object)LinkHelper.absoluteUrl(DEFAULT_AVATAR_PATH, this.applicationProperties));
        }
        catch (MalformedURLException e) {
            logger.warn("Unexpected error building url for default avatar (/download/resources/com.atlassian.confluence.plugins.confluence-hipchat-integration-plugin/images/avatar.png). Returning none.");
            return Option.none();
        }
    }

    private String userLinkHtml(Option<UserKey> userKey) {
        if (userKey.isDefined()) {
            ConfluenceUser user = this.userAccessor.getExistingUserByKey((UserKey)userKey.get());
            return String.format("<a href=\"%s/%s\">%s</a>", this.applicationProperties.getBaseUrl(UrlMode.CANONICAL), this.personalInformationManager.getOrCreatePersonalInformation((User)user).getUrlPath(), GeneralUtil.escapeXml((String)user.getFullName()));
        }
        return String.format("<i>%s</i>", this.i18nResolver.getText("hipchat.notification.anonymous"));
    }
}

