/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.upgrade.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Map;
import net.java.ao.DBParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SpaceToRoomBandanaToAoMigrator {
    private static final Logger logger = LoggerFactory.getLogger(SpaceToRoomBandanaToAoMigrator.class);
    @VisibleForTesting
    static final String LEGACY_PLUGIN_KEY = "com.atlassian.labs.hipchat";
    static final String LEGACY_HIPCHAT_AUTH_TOKEN_KEY = "hipchat-auth-token";
    static final String PAGE_CREATE_BANDANA_KEY = "PageCreate";
    static final String PAGE_UPDATE_BANDANA_KEY = "PageUpdate";
    static final String BLOG_CREATE_BANDANA_KEY = "BlogCreate";
    static final String PAGE_CREATE_BANDANA_LEGACY_KEY = "pc";
    static final String PAGE_UPDATE_BANDANA_LEGACY_KEY = "pu";
    static final String BLOG_CREATE_BANDANA_LEGACY_KEY = "";
    private static final Map<String, String[]> spaceToRoomNotificationsToMessageTypeKeys = ImmutableMap.of((Object)"PageCreate", (Object)new String[]{"PageCreate", "pc"}, (Object)"PageUpdate", (Object)new String[]{"PageUpdate", "pu"}, (Object)"BlogCreate", (Object)new String[]{"BlogCreate", ""});

    private SpaceToRoomBandanaToAoMigrator() {
    }

    static void migrateData(BandanaManager bandanaManager, ActiveObjects activeObjects) {
        Preconditions.checkNotNull((Object)bandanaManager);
        logger.info("Beginning Hipchat space to room data migration");
        activeObjects.migrate(new Class[]{AOEntityToRoomMapping.class});
        ConfluenceBandanaContext context = new ConfluenceBandanaContext(LEGACY_PLUGIN_KEY);
        Iterable spaceKeys = bandanaManager.getKeys((BandanaContext)context);
        for (String spaceKey : spaceKeys) {
            String[] legacyParts;
            if (spaceKey.equals(LEGACY_HIPCHAT_AUTH_TOKEN_KEY)) continue;
            String bandanaConfigValue = (String)bandanaManager.getValue((BandanaContext)context, spaceKey);
            for (String legacyPart : legacyParts = StringUtils.split((String)bandanaConfigValue, (String)",")) {
                Option<Pair<String, String>> part = SpaceToRoomBandanaToAoMigrator.convertFromLegacyPart(legacyPart);
                if (part.isDefined()) {
                    Pair config = (Pair)part.get();
                    String roomId = (String)config.left();
                    String notificationTypeKey = (String)config.right();
                    AOEntityToRoomMapping entityToRoomMapping = (AOEntityToRoomMapping)activeObjects.create(AOEntityToRoomMapping.class, new DBParam[0]);
                    entityToRoomMapping.setEntityKey(spaceKey);
                    entityToRoomMapping.setRoomId(roomId);
                    entityToRoomMapping.setMessageTypeKey(notificationTypeKey);
                    entityToRoomMapping.save();
                    continue;
                }
                logger.warn("Unable to extract a part from configuration (" + legacyPart + "). Skipping this part.");
            }
        }
        logger.info("Completed Hipchat space to room data migration");
    }

    private static Option<Pair<String, String>> convertFromLegacyPart(String legacyPart) {
        String spaceToRoomNotification;
        String[] parts = StringUtils.split((String)legacyPart.trim(), (String)":");
        int partCount = parts.length;
        if (partCount == 0) {
            return Option.none();
        }
        if (partCount == 1) {
            spaceToRoomNotification = BLOG_CREATE_BANDANA_KEY;
        } else {
            String notificationType = parts[1];
            spaceToRoomNotification = SpaceToRoomBandanaToAoMigrator.parseSpaceToRoomNotification(notificationType);
            if (spaceToRoomNotification == null) {
                return Option.none();
            }
        }
        String roomId = parts[0];
        Option notificationPair = Option.option((Object)Pair.pair((Object)roomId, (Object)spaceToRoomNotification));
        return notificationPair;
    }

    private static String parseSpaceToRoomNotification(String notificationType) {
        for (Map.Entry<String, String[]> entry : spaceToRoomNotificationsToMessageTypeKeys.entrySet()) {
            String[] messageTypeKeys;
            for (String messageTypeKey : messageTypeKeys = entry.getValue()) {
                if (!messageTypeKey.equals(notificationType)) continue;
                String spaceToRoomNotification = entry.getKey();
                return spaceToRoomNotification;
            }
        }
        return null;
    }
}

