/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.service;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.TinyUrl;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.events.SpaceToRoomLinkedEvent;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.icons.ADGIcon;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPI;
import com.atlassian.plugins.hipchat.api.notification.DefaultHipChatNotificationOptions;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.net.ResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Internal
public class SpaceToRoomNotificationService
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(SpaceToRoomNotificationService.class);
    private final HipChatCompatAPI hipChatCompatApi;
    private final ApplicationProperties applicationProperties;
    private final EventPublisher eventPublisher;
    private final I18NBeanFactory i18NBeanFactory;
    private final SpaceToRoomNotificationProvider spaceToRoomNotificationProvider;

    public SpaceToRoomNotificationService(HipChatCompatAPI hipChatCompatApi, ApplicationProperties applicationProperties, EventPublisher eventPublisher, I18NBeanFactory i18NBeanFactory, SpaceToRoomNotificationProvider spaceToRoomNotificationProvider) {
        this.hipChatCompatApi = hipChatCompatApi;
        this.applicationProperties = applicationProperties;
        this.eventPublisher = eventPublisher;
        this.i18NBeanFactory = i18NBeanFactory;
        this.spaceToRoomNotificationProvider = spaceToRoomNotificationProvider;
    }

    @EventListener
    public void hipChatNotifications(Object event) {
        log.debug("Obtaining room notifications for event {}", event);
        try {
            Iterable<SpaceToRoomNotificationProvider.RoomNotification> notifications = this.spaceToRoomNotificationProvider.getNotificationsForEvent(event);
            this.sendMessages(notifications);
        }
        catch (RuntimeException ex) {
            log.error("Failed to obtain hipchat notifications for event {}: {}", event, (Object)ex.getMessage());
            log.debug("Failed to obtain hipchat notifications for event {}", event, (Object)ex);
        }
    }

    @EventListener
    public void spaceToRoomLinked(SpaceToRoomLinkedEvent event) {
        block2: {
            Space space = event.getSpace();
            I18NBean i18n = this.i18NBeanFactory.getI18NBean();
            String msg = i18n.getText("hipchat.notification.room-linked", new Object[]{ADGIcon.SUCCESS.render(), this.createLink((AbstractPage)space.getHomePage(), (Option<String>)Option.option((Object)space.getDisplayTitle()))});
            try {
                this.hipChatCompatApi.notifyRoom(event.getRoom().getRoomId(), msg, HipChatNotificationOptions.GREEN);
            }
            catch (ResponseException e) {
                log.warn("Unable to send Hipchat Notification. Reason:", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block2;
                log.debug("Detailed exception:", (Throwable)e);
            }
        }
    }

    private void sendMessages(Iterable<SpaceToRoomNotificationProvider.RoomNotification> notifications) {
        for (SpaceToRoomNotificationProvider.RoomNotification notification : notifications) {
            try {
                String roomId = notification.getRoomId();
                String message = notification.getMessage();
                boolean notify = notification.isNotify();
                DefaultHipChatNotificationOptions.DefaultHipChatNotificationOptionsBuilder options = new DefaultHipChatNotificationOptions.DefaultHipChatNotificationOptionsBuilder();
                options.setBackgroundColor(Option.some((Object)MessageBgColor.GRAY));
                options.setNotifyingClients(notify);
                options.setCard(notification.getCard());
                this.hipChatCompatApi.notifyRoom(roomId, message, (HipChatNotificationOptions)options.build());
            }
            catch (ResponseException e) {
                log.warn("Unable to send Hipchat Notification. Reason:", (Object)e.getMessage());
                if (!log.isDebugEnabled()) continue;
                log.debug("Detailed exception:", (Throwable)e);
            }
        }
    }

    private String createLink(AbstractPage page, Option<String> linkText) {
        return String.format("<a href=\"%s\"><b>%s</b></a>", GeneralUtil.escapeForHtmlAttribute((String)this.tinyLink(page)), GeneralUtil.escapeXMLCharacters((String)(linkText.isDefined() ? (String)linkText.get() : page.getTitle())));
    }

    private String tinyLink(AbstractPage page) {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/x/" + new TinyUrl(page).getIdentifier();
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("Register Hipchat event listener");
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        log.debug("Un-register Hipchat event listener");
        this.eventPublisher.unregister((Object)this);
    }
}

