/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.service;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConfluenceGlanceUpdateMetadata;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.ConnectSynchronisationTasks;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.HipChatSynchronisationTaskConsumer;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.model.SynchronisationGoal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.ConnectEnablementManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatNotificationEnablementStateProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSidebarUpdater;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSynchronisationProcessor;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.util.ConfluenceConnectUtil;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.ResourceError;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.connect.descriptor.extensions.Glance;
import com.atlassian.hipchat.api.connect.descriptor.extensions.WebPanel;
import com.atlassian.hipchat.api.glances.GlanceData;
import com.atlassian.hipchat.api.glances.GlanceUpdateData;
import com.atlassian.hipchat.api.glances.RoomAddonUiUpdateData;
import com.atlassian.hipchat.api.rooms.RoomService;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.routes.RateLimitThresholdEvent;
import com.atlassian.plugins.hipchat.tasks.HipChatTasksExecutor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class DefaultHipChatSynchronisationProcessor
implements InitializingBean,
DisposableBean,
HipChatSynchronisationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatSynchronisationProcessor.class);
    private static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final long INITIATE_SYNCHRONISATION_DELAY_MillISECONDS = 1L;
    private static final long MIN_RATE_LIMIT_RETRY_DELAY_MillISECONDS = 5000L;
    private static final long MAX_RATE_LIMIT_RETRY_DELAY_MillISECONDS = 300000L;
    private static final long RATE_LIMIT_RESET_BUFFER_PERIOD_MillISECONDS = 10000L;
    private static final long ENABLEMENT_RETRY_PERIOD_MillISECONDS = 30000L;
    private final HipChatSidebarUpdater hipChatSidebarUpdater;
    private final HipChatLinkProvider hipChatLinkProvider;
    private final EventPublisher eventPublisher;
    private final EntityToRoomMappingManager entityToRoomMappingManager;
    private final SettingsManager settingsManager;
    private final SpaceManager spaceManager;
    private final HipChatTasksExecutor hipChatTasksExecutor;
    private final HipChatNotificationEnablementStateProvider hipChatNotificationEnablementStateProvider;
    private final I18nResolver i18nResolver;
    private final ConnectEnablementManager connectEnablementManager;
    private final AtomicLong lastRateLimitResetTimeMilliseconds = new AtomicLong(0L);

    public DefaultHipChatSynchronisationProcessor(HipChatSidebarUpdater hipChatSidebarUpdater, HipChatLinkProvider hipChatLinkProvider, EventPublisher eventPublisher, EntityToRoomMappingManager entityToRoomMappingManager, SettingsManager settingsManager, SpaceManager spaceManager, HipChatTasksExecutor hipChatTasksExecutor, HipChatNotificationEnablementStateProvider hipChatNotificationEnablementStateProvider, I18nResolver i18nResolver, ConnectEnablementManager connectEnablementManager) {
        this.hipChatSidebarUpdater = hipChatSidebarUpdater;
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.eventPublisher = eventPublisher;
        this.entityToRoomMappingManager = entityToRoomMappingManager;
        this.settingsManager = settingsManager;
        this.spaceManager = spaceManager;
        this.hipChatTasksExecutor = hipChatTasksExecutor;
        this.hipChatNotificationEnablementStateProvider = hipChatNotificationEnablementStateProvider;
        this.i18nResolver = i18nResolver;
        this.connectEnablementManager = connectEnablementManager;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.hipChatNotificationEnablementStateProvider.isNotificationsEnabled()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Register Hipchat synchronisation processor event listener");
            }
            this.eventPublisher.register((Object)this);
        } else {
            logger.info("Detected notification processing is disabled.");
        }
    }

    public void destroy() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Un-register Hipchat synchronisation processor event listener");
        }
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public void initiateSynchronisation() {
        TaskProcessor taskProcessor = new TaskProcessor();
        taskProcessor.schedule(1L, TimeUnit.MILLISECONDS);
    }

    @EventListener
    public void handleRateLimitThresholdEvent(RateLimitThresholdEvent rateLimitThresholdEvent) {
        long resetTimeMilliseconds = rateLimitThresholdEvent.getReset();
        this.lastRateLimitResetTimeMilliseconds.set(resetTimeMilliseconds);
    }

    private class TaskProcessor
    implements HipChatSynchronisationTaskConsumer<RoomService>,
    Runnable {
        private final ConnectSynchronisationTasks synchronisationTasks;
        private final ConnectSynchronisationTasks.IterationKey iterationKey = new ConnectSynchronisationTasks.IterationKey();

        TaskProcessor() {
            this.synchronisationTasks = ConnectSynchronisationTasks.getInstance();
        }

        public void schedule(long delay, TimeUnit timeUnit) {
            DefaultHipChatSynchronisationProcessor.this.hipChatTasksExecutor.schedule((Runnable)this, delay, timeUnit);
        }

        @Override
        public void reschedule(long delay, TimeUnit timeUnit) {
            TaskProcessor processor = new TaskProcessor();
            processor.schedule(delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public boolean processSynchronisationTask(String roomId, SynchronisationGoal synchronisationGoal, RoomService roomService) {
            boolean rateLimitHit;
            String glanceKey = ConfluenceConnectUtil.buildGlanceKey(roomId);
            String webPanelKey = ConfluenceConnectUtil.buildWebPanelKey(roomId);
            if (synchronisationGoal == SynchronisationGoal.REMOVE_IF_LAST_MAPPING_DELETED) {
                int mappingCount = DefaultHipChatSynchronisationProcessor.this.entityToRoomMappingManager.countForRoom(roomId);
                if (mappingCount == 0) {
                    Promise deleteGlancePromise = roomService.deleteRoomGlance(roomId, glanceKey);
                    Promise deleteWebPanelPromise = roomService.deleteRoomWebPanel(roomId, webPanelKey);
                    Promise<Result<Void>> disablePromise = DefaultHipChatSynchronisationProcessor.this.hipChatSidebarUpdater.pushSidebarDisabledEvent(roomId, glanceKey);
                    rateLimitHit = this.rateLimitHit(deleteGlancePromise, deleteWebPanelPromise, disablePromise);
                } else {
                    Promise<Result<Void>> updatePromise = DefaultHipChatSynchronisationProcessor.this.hipChatSidebarUpdater.pushSpaceToRoomMappingUpdateEvent(roomId, glanceKey);
                    rateLimitHit = this.rateLimitHit(updatePromise);
                }
            } else if (synchronisationGoal == SynchronisationGoal.REMOVE_UNCONDITIONALLY) {
                Promise deleteGlancePromise = roomService.deleteRoomGlance(roomId, glanceKey);
                Promise deleteWebPanelPromise = roomService.deleteRoomWebPanel(roomId, webPanelKey);
                Promise<Result<Void>> disablePromise = DefaultHipChatSynchronisationProcessor.this.hipChatSidebarUpdater.pushSidebarDisabledEvent(roomId, glanceKey);
                rateLimitHit = this.rateLimitHit(deleteGlancePromise, deleteWebPanelPromise, disablePromise);
            } else if (synchronisationGoal == SynchronisationGoal.UPDATE_OR_CREATE) {
                Promise<Result<Void>> glanceExistsPromise = this.ensureGlanceExists(roomService, roomId, glanceKey);
                Promise<Result<Void>> webPanelExistsPromise = this.ensureWebPanelExists(roomService, roomId, webPanelKey);
                rateLimitHit = this.rateLimitHit(glanceExistsPromise, webPanelExistsPromise);
            } else if (synchronisationGoal == SynchronisationGoal.UPDATE_GLANCE) {
                Promise<Result<Void>> updatePromise = this.updateGlance(roomService, DefaultHipChatSynchronisationProcessor.this.i18nResolver, roomId, glanceKey);
                rateLimitHit = this.rateLimitHit(updatePromise);
            } else {
                logger.warn("Unexpected synchronisation goal: " + (Object)((Object)synchronisationGoal));
                rateLimitHit = false;
            }
            if (rateLimitHit) {
                logger.warn("Rate limit response detected. Scheduling another attempt to synchronise later...");
                this.scheduleRetry();
            }
            boolean success = !rateLimitHit;
            return success;
        }

        @Override
        public void run() {
            if (DefaultHipChatSynchronisationProcessor.this.connectEnablementManager.isEnabled()) {
                Option<HipChatLink> hipChatLinkOption = this.getHipChatLink();
                if (hipChatLinkOption.isDefined()) {
                    HipChatLink hipChatLink = (HipChatLink)hipChatLinkOption.get();
                    HipChatAPI addonApi = hipChatLink.getAddonApi();
                    RoomService roomService = addonApi.rooms();
                    this.synchronisationTasks.iteratePendingTasks(this.iterationKey, this, roomService);
                } else {
                    logger.warn("Unable to synchronise with Hipchat because the link has been removed.");
                    this.synchronisationTasks.clearTasks();
                }
            } else if (this.iterationKey.isValid()) {
                if (this.synchronisationTasks.hasTasks()) {
                    this.reschedule(30000L, TimeUnit.MILLISECONDS);
                }
            } else {
                logger.trace("Obsolete task detected (model updated since task was scheduled).");
            }
        }

        private void scheduleRetry() {
            long now = System.currentTimeMillis();
            long resetTimeMilliseconds = DefaultHipChatSynchronisationProcessor.this.lastRateLimitResetTimeMilliseconds.get();
            long resetTimeWithBufferMilliseconds = resetTimeMilliseconds + 10000L;
            long delayToResetTimeMilliseconds = resetTimeWithBufferMilliseconds - now;
            if (delayToResetTimeMilliseconds < 5000L) {
                delayToResetTimeMilliseconds = 5000L;
            } else if (delayToResetTimeMilliseconds > 300000L) {
                delayToResetTimeMilliseconds = 300000L;
            }
            logger.warn("Reached Hipchat rate limit. Scheduling a retry after " + delayToResetTimeMilliseconds + "ms...");
            this.reschedule(delayToResetTimeMilliseconds, TimeUnit.MILLISECONDS);
        }

        private Promise<Result<Void>> updateGlance(RoomService roomService, I18nResolver i18nResolver, String roomId, String glanceKey) {
            ConfluenceGlanceUpdateMetadata metadata = new ConfluenceGlanceUpdateMetadata("glance-updated");
            GlanceData glanceData = ConfluenceConnectUtil.buildGlanceData(roomId, DefaultHipChatSynchronisationProcessor.this.settingsManager, DefaultHipChatSynchronisationProcessor.this.entityToRoomMappingManager, DefaultHipChatSynchronisationProcessor.this.spaceManager, i18nResolver, metadata);
            GlanceUpdateData glanceUpdateData = new GlanceUpdateData(glanceKey, glanceData);
            RoomAddonUiUpdateData roomAddonUiUpdateData = new RoomAddonUiUpdateData.Builder().addGlance(glanceUpdateData).build();
            return roomService.updateRoomAddonUi(roomId, roomAddonUiUpdateData);
        }

        private Promise<Result<Void>> ensureGlanceExists(RoomService roomService, String roomId, String glanceKey) {
            Glance glance = ConfluenceConnectUtil.buildGlanceDefinition(roomId, DefaultHipChatSynchronisationProcessor.this.settingsManager, DefaultHipChatSynchronisationProcessor.this.entityToRoomMappingManager, DefaultHipChatSynchronisationProcessor.this.spaceManager);
            Promise glanceSummaryResultPromise = roomService.getRoomGlance(roomId, glanceKey);
            Result glanceSummaryResult = (Result)glanceSummaryResultPromise.claim();
            if (glanceSummaryResult.isSuccess()) {
                return DefaultHipChatSynchronisationProcessor.this.hipChatSidebarUpdater.pushSpaceToRoomMappingUpdateEvent(roomId, glanceKey);
            }
            return roomService.createRoomGlance(roomId, glance);
        }

        private Promise<Result<Void>> ensureWebPanelExists(RoomService roomService, String roomId, String webPanelKey) {
            Promise glanceSummaryResultPromise = roomService.getRoomGlance(roomId, webPanelKey);
            Result glanceSummaryResult = (Result)glanceSummaryResultPromise.claim();
            if (glanceSummaryResult.isSuccess()) {
                return DefaultHipChatSynchronisationProcessor.this.hipChatSidebarUpdater.pushSpaceToRoomMappingUpdateEvent(roomId, webPanelKey);
            }
            WebPanel webPanel = ConfluenceConnectUtil.buildWebPanelDefinition(roomId, DefaultHipChatSynchronisationProcessor.this.settingsManager);
            return roomService.createRoomWebPanel(roomId, webPanel);
        }

        private Option<HipChatLink> getHipChatLink() {
            try {
                return DefaultHipChatSynchronisationProcessor.this.hipChatLinkProvider.getDefaultLink();
            }
            catch (IllegalStateException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Ignoring inability to get Hipchat link - this occurs during startup when AO is not yet ready.");
                }
                return Option.none();
            }
        }

        private boolean rateLimitHit(Promise<Result<Void>> promise) {
            Result result = (Result)promise.claim();
            return this.rateLimitHit((Result<Void>)result);
        }

        private boolean rateLimitHit(Promise<Result<Void>> ... promises) {
            Promise promisesList = Promises.when(promises);
            List results = (List)promisesList.claim();
            for (Result result : results) {
                if (!this.rateLimitHit((Result<Void>)result)) continue;
                return true;
            }
            return false;
        }

        private boolean rateLimitHit(Result<Void> result) {
            if (result.isSuccess()) {
                return false;
            }
            ResourceError resourceError = result.error();
            int statusCode = resourceError.getStatusCode();
            return statusCode == 429;
        }
    }
}

