/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.service;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomConfig;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.AOEntityToRoomMapping;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomConfigManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.ao.EntityToRoomMappingManager;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.BatchedHipChatApiRoomProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.RoomProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.SpaceToRoomConfiguration;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.configuration.SpaceToRoomSettings;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.notifications.SpaceToRoomNotificationProvider;
import com.atlassian.confluence.plugins.hipchat.spacetoroom.service.HipChatSpaceToRoomService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.hipchat.api.compat.HipChatCompatAPI;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DefaultHipChatSpaceToRoomService
implements HipChatSpaceToRoomService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHipChatSpaceToRoomService.class);
    private final SpaceManager spaceManager;
    private final EntityToRoomMappingManager entityToRoomMappingManager;
    private final EntityToRoomConfigManager entityToRoomConfigManager;
    private final HipChatCompatAPI hipChatCompatApi;
    private final SpaceToRoomNotificationProvider spaceToRoomNotificationProvider;
    private Function<SpaceToRoomConfiguration.Builder, SpaceToRoomConfiguration> buildTransformer = new Function<SpaceToRoomConfiguration.Builder, SpaceToRoomConfiguration>(){

        public SpaceToRoomConfiguration apply(@Nullable SpaceToRoomConfiguration.Builder builder) {
            return builder.build();
        }
    };

    public DefaultHipChatSpaceToRoomService(HipChatCompatAPI hipChatCompatApi, SpaceManager spaceManager, EntityToRoomMappingManager entityToRoomMappingManager, EntityToRoomConfigManager entityToRoomConfigManager, SpaceToRoomNotificationProvider spaceToRoomNotificationProvider) {
        this.hipChatCompatApi = hipChatCompatApi;
        this.spaceManager = spaceManager;
        this.entityToRoomMappingManager = entityToRoomMappingManager;
        this.entityToRoomConfigManager = entityToRoomConfigManager;
        this.spaceToRoomNotificationProvider = spaceToRoomNotificationProvider;
    }

    @Override
    public Iterable<SpaceToRoomConfiguration> getAllSpaceToRoomLinks() {
        if (this.hipChatCompatApi.isEnabled()) {
            Space space;
            SpaceToRoomConfiguration.Builder builder;
            String spaceKey;
            Iterable<AOEntityToRoomMapping> mappings = this.entityToRoomMappingManager.getAll();
            Iterable<AOEntityToRoomConfig> configs = this.entityToRoomConfigManager.getAll();
            Set<String> roomIds = this.getAllRoomIds(mappings, configs);
            RoomProvider roomProvider = BatchedHipChatApiRoomProvider.createFromRoomIds(this.hipChatCompatApi, roomIds);
            HashMap<String, SpaceToRoomConfiguration.Builder> spaceBuilders = new HashMap<String, SpaceToRoomConfiguration.Builder>();
            for (AOEntityToRoomMapping mapping : mappings) {
                spaceKey = mapping.getEntityKey();
                builder = (SpaceToRoomConfiguration.Builder)spaceBuilders.get(spaceKey);
                if (builder == null && (space = this.spaceManager.getSpace(spaceKey)) != null) {
                    builder = this.newConfigBuilder(space, roomProvider);
                    spaceBuilders.put(spaceKey, builder);
                }
                if (builder == null) continue;
                this.addAOEntityRoomMappingsToBuilder(mapping, builder.getSettingsBuilder(mapping.getRoomId()));
            }
            for (AOEntityToRoomConfig config : configs) {
                spaceKey = config.getEntityKey();
                builder = (SpaceToRoomConfiguration.Builder)spaceBuilders.get(spaceKey);
                if (builder == null && (space = this.spaceManager.getSpace(spaceKey)) != null) {
                    builder = this.newConfigBuilder(space, roomProvider);
                    spaceBuilders.put(spaceKey, builder);
                }
                if (builder == null) continue;
                this.addAOEntityToRoomConfigToBuilder(config, builder.getSettingsBuilder(config.getRoomId()));
            }
            return Iterables.transform(spaceBuilders.values(), this.buildTransformer);
        }
        return ImmutableList.of();
    }

    @Override
    public List<SpaceToRoomConfiguration> getAllSpaceToRoomConfigurations() {
        return ImmutableList.copyOf(this.getAllSpaceToRoomLinks());
    }

    @Override
    public SpaceToRoomConfiguration getSpaceToRoomConfiguration(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        Iterable<AOEntityToRoomMapping> mappings = this.entityToRoomMappingManager.getForEntity(spaceKey);
        Iterable<AOEntityToRoomConfig> configs = this.entityToRoomConfigManager.getForEntity(spaceKey);
        Set<String> roomIds = this.getAllRoomIds(mappings, configs);
        RoomProvider roomProvider = BatchedHipChatApiRoomProvider.createFromRoomIds(this.hipChatCompatApi, roomIds);
        SpaceToRoomConfiguration.Builder builder = this.newConfigBuilder(space, roomProvider);
        this.addRoomMappingsToBuilder(mappings, builder);
        this.addRoomConfigsToBuilder(configs, builder);
        return builder.build();
    }

    @Override
    public Option<SpaceToRoomSettings> getSpaceToRoomSettings(String spaceKey, String roomId) {
        SpaceToRoomSettings.Builder builder = new SpaceToRoomSettings.Builder();
        Iterable<AOEntityToRoomMapping> mappings = this.entityToRoomMappingManager.getForEntityAndRoom(spaceKey, roomId);
        Iterable<AOEntityToRoomConfig> configs = this.entityToRoomConfigManager.getForEntityAndRoom(spaceKey, roomId);
        if (!mappings.iterator().hasNext() && !configs.iterator().hasNext()) {
            return Option.none();
        }
        this.addRoomMappingsToBuilder(mappings, builder);
        this.addRoomConfigsToBuilder(configs, builder);
        return Option.some((Object)builder.build());
    }

    @Override
    public boolean hasSpaceToRoomConfiguration(String spaceKey) {
        return this.entityToRoomMappingManager.hasConfigurationForEntity(spaceKey);
    }

    @Override
    public boolean hasMappingForEntityRoomAndType(String entity, String roomId, NotificationType type) {
        return this.entityToRoomMappingManager.hasConfigurationForEntityRoomAndType(entity, roomId, type);
    }

    @VisibleForTesting
    SpaceToRoomConfiguration.Builder newConfigBuilder(Space space, RoomProvider roomProvider) {
        return new SpaceToRoomConfiguration.Builder(space, roomProvider);
    }

    @Override
    public void addNotificationForSpaceAndRoom(String spaceKey, String roomId, NotificationType notificationType) {
        this.entityToRoomMappingManager.addNotificationForEntityAndRoom(spaceKey, roomId, notificationType);
    }

    @Override
    public void removeNotificationForSpaceAndRoom(String spaceKey, String roomId, NotificationType notificationType) {
        this.entityToRoomMappingManager.removeNotificationForEntityAndRoom(spaceKey, roomId, notificationType);
    }

    @Override
    public void removeNotificationsForSpaceAndRoom(String spaceKey, String roomId) {
        this.entityToRoomMappingManager.removeNotificationsForEntityAndRoom(spaceKey, roomId);
        this.entityToRoomConfigManager.removeConfigurationForEntityAndRoom(spaceKey, roomId);
    }

    @Override
    public int removeNotificationsForSpace(String spaceKey) {
        this.entityToRoomConfigManager.removeConfigurationForEntity(spaceKey);
        return this.entityToRoomMappingManager.removeNotificationsForEntity(spaceKey);
    }

    @Override
    public void setClientNotifyForSpaceAndRoom(String spaceKey, String roomId, boolean notifyClient) {
        this.entityToRoomConfigManager.setNotifyClient(spaceKey, roomId, notifyClient);
    }

    private void addRoomMappingsToBuilder(Iterable<AOEntityToRoomMapping> mappings, SpaceToRoomConfiguration.Builder builder) {
        for (AOEntityToRoomMapping mapping : mappings) {
            SpaceToRoomSettings.Builder settingsBuilder = builder.getSettingsBuilder(mapping.getRoomId());
            this.addAOEntityRoomMappingsToBuilder(mapping, settingsBuilder);
        }
    }

    private void addRoomConfigsToBuilder(Iterable<AOEntityToRoomConfig> configs, SpaceToRoomConfiguration.Builder builder) {
        for (AOEntityToRoomConfig config : configs) {
            SpaceToRoomSettings.Builder settingsBuilder = builder.getSettingsBuilder(config.getRoomId());
            this.addAOEntityToRoomConfigToBuilder(config, settingsBuilder);
        }
    }

    private void addRoomMappingsToBuilder(Iterable<AOEntityToRoomMapping> mappings, SpaceToRoomSettings.Builder builder) {
        for (AOEntityToRoomMapping mapping : mappings) {
            this.addAOEntityRoomMappingsToBuilder(mapping, builder);
        }
    }

    private void addRoomConfigsToBuilder(Iterable<AOEntityToRoomConfig> configs, SpaceToRoomSettings.Builder builder) {
        for (AOEntityToRoomConfig config : configs) {
            this.addAOEntityToRoomConfigToBuilder(config, builder);
        }
    }

    private void addAOEntityRoomMappingsToBuilder(AOEntityToRoomMapping mapping, SpaceToRoomSettings.Builder builder) {
        String notificationTypeKey = mapping.getMessageTypeKey();
        Option<NotificationType> spaceToRoomNotificationOption = this.spaceToRoomNotificationProvider.getNotificationTypeForKey(notificationTypeKey);
        if (spaceToRoomNotificationOption.isDefined()) {
            NotificationType spaceToRoomNotification = (NotificationType)spaceToRoomNotificationOption.get();
            builder.addNotificationType(spaceToRoomNotification);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unable to parse SpaceToRoomNotification from '" + notificationTypeKey + "'.");
        }
    }

    private void addAOEntityToRoomConfigToBuilder(AOEntityToRoomConfig config, SpaceToRoomSettings.Builder builder) {
        boolean notifyClient = config.isNotifyClient();
        builder.setNotifyClient(notifyClient);
    }

    private Set<String> getAllRoomIds(Iterable<AOEntityToRoomMapping> mappings, Iterable<AOEntityToRoomConfig> configs) {
        HashSet<String> roomIds = new HashSet<String>();
        if (mappings != null) {
            for (AOEntityToRoomMapping mapping : mappings) {
                roomIds.add(mapping.getRoomId());
            }
        }
        if (configs != null) {
            for (AOEntityToRoomConfig config : configs) {
                roomIds.add(config.getRoomId());
            }
        }
        return roomIds;
    }
}

