/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.model;

public enum MyWorkType {
    ALL{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitAll();
        }
    }
    ,
    MENTIONED_IN{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitMentionedIn();
        }
    }
    ,
    RECENTLY_WORKED_ON{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitRecentlyWorkedOn();
        }
    }
    ,
    RECENTLY_VISITED{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitRecentlyVisited();
        }
    }
    ,
    SAVED_FOR_LATER{

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitSavedForLater();
        }
    };


    public static MyWorkType parseMyWorkType(String myWorkTypeString) {
        for (MyWorkType myWorkType : MyWorkType.values()) {
            if (!myWorkType.name().equalsIgnoreCase(myWorkTypeString)) continue;
            return myWorkType;
        }
        return null;
    }

    public abstract <T> T accept(Visitor<T> var1);

    public static interface Visitor<T> {
        public T visitAll();

        public T visitMentionedIn();

        public T visitRecentlyWorkedOn();

        public T visitRecentlyVisited();

        public T visitSavedForLater();
    }
}

