/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.hipchat.spacetoroom.actions;

import com.atlassian.confluence.plugins.hipchat.spacetoroom.actions.InviteUserWizardService;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.plugins.hipchat.api.HipChatDarkFeatureService;
import com.atlassian.plugins.hipchat.api.HipChatLink;
import com.atlassian.plugins.hipchat.api.link.HipChatLinkProvider;
import com.atlassian.plugins.hipchat.api.routes.HipChatRoutesProvider;
import com.atlassian.plugins.hipchat.api.user.HipChatUserFinder;
import com.atlassian.plugins.hipchat.api.user.InviteUserPageResolver;
import com.atlassian.plugins.hipchat.spi.HipChatRoutesProviderFactory;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.webwork.ServletActionContext;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ConfluenceHipChatInviteAction
extends AbstractSpaceAdminAction {
    private final HipChatLinkProvider hipChatLinkProvider;
    private final HipChatRoutesProviderFactory hipChatRoutesProviderFactory;
    private final HipChatUserFinder hipChatUserFinder;
    private final HipChatDarkFeatureService hipChatDarkFeatureService;
    private final InviteUserPageResolver inviteUserPageResolver;
    private final HipChatRoutesProvider hipChatRoutesProvider;
    private final InviteUserWizardService inviteUserWizardService;
    private Option<HipChatLink> defaultLink;
    private HipChatRoutesProvider routesProvider;

    public ConfluenceHipChatInviteAction(HipChatLinkProvider hipChatLinkProvider, HipChatRoutesProviderFactory hipChatRoutesProviderFactory, HipChatUserFinder hipChatUserFinder, HipChatDarkFeatureService hipChatDarkFeatureService, InviteUserPageResolver inviteUserPageResolver, HipChatRoutesProvider hipChatRoutesProvider, InviteUserWizardService inviteUserWizardService) {
        this.hipChatLinkProvider = hipChatLinkProvider;
        this.hipChatRoutesProviderFactory = hipChatRoutesProviderFactory;
        this.hipChatUserFinder = hipChatUserFinder;
        this.hipChatDarkFeatureService = hipChatDarkFeatureService;
        this.inviteUserPageResolver = inviteUserPageResolver;
        this.hipChatRoutesProvider = hipChatRoutesProvider;
        this.inviteUserWizardService = inviteUserWizardService;
    }

    public String execute() throws Exception {
        if (!this.hipChatDarkFeatureService.isInviteToHipChatEnabled()) {
            return "configure";
        }
        Option link = this.hipChatLinkProvider.getDefaultLink();
        if (link.isEmpty()) {
            return "install";
        }
        HipChatRoutesProvider routesProvider = this.hipChatRoutesProviderFactory.getProvider((Map)ImmutableMap.of((Object)"space", (Object)this.getSpace()));
        this.setRoutesProvider(routesProvider);
        this.setDefaultLink((Option<HipChatLink>)link);
        return "success";
    }

    public String getGroupName() {
        if (this.defaultLink.isDefined()) {
            return ((HipChatLink)this.defaultLink.get()).getGroupName();
        }
        return null;
    }

    public String getApiUrl() {
        if (this.defaultLink.isDefined()) {
            return ((HipChatLink)this.defaultLink.get()).getApiUrl();
        }
        return null;
    }

    public String getHipChatUserName() {
        ConfluenceUser user = this.getAuthenticatedUser();
        Option hipChatUser = this.hipChatUserFinder.findHipChatUserIdAndName(user.getKey());
        if (hipChatUser.isEmpty()) {
            return null;
        }
        return (String)((Pair)hipChatUser.get()).right();
    }

    public String getInvitePageToRender() {
        return this.inviteUserPageResolver.resolvePageToRender().name();
    }

    public String getHipChatConfigureUrl() {
        return this.routesProvider.getAdminConfigurationPage().toString();
    }

    public void setDefaultLink(Option<HipChatLink> link) {
        this.defaultLink = link;
    }

    public void setRoutesProvider(HipChatRoutesProvider routesProvider) {
        this.routesProvider = routesProvider;
    }

    public String getHipChatApiUrl() {
        HipChatLink link = (HipChatLink)this.defaultLink.get();
        String apiUrl = link.getApiUrl();
        return apiUrl;
    }

    public String getFindInviteUsersURI() {
        URI findInviteUsersURI = this.routesProvider.getFindInviteUsersURI();
        return findInviteUsersURI.toString();
    }

    public String getAdminConfigurationPageURI() {
        URI adminConfigurationPageURI = this.routesProvider.getAdminConfigurationPage();
        return adminConfigurationPageURI.toString();
    }

    public String getUninstallURI() {
        URI uninstallURI = this.routesProvider.getUninstall();
        return uninstallURI.toString();
    }

    public boolean isInitialInstall() {
        return this.inviteUserWizardService.isInitialInstall();
    }

    public boolean isLoggedInToHipChat() {
        HipChatLink link = (HipChatLink)this.defaultLink.get();
        Option personalHipChatAPIOption = link.getPersonalApi();
        boolean loggedInToHipChat = personalHipChatAPIOption.isDefined();
        return loggedInToHipChat;
    }

    public boolean isShowRemoveButton() {
        return true;
    }

    public boolean isInviteEnabled() {
        boolean enabled = this.hipChatDarkFeatureService.isInviteToHipChatEnabled();
        return enabled;
    }

    public boolean isInviteUsersComplete() {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpSession session = request.getSession();
        Boolean inviteUsersComplete = (Boolean)session.getAttribute("hipchat.integration.invite.complete");
        if (inviteUsersComplete == null) {
            inviteUsersComplete = Boolean.FALSE;
        }
        return inviteUsersComplete;
    }
}

