define("confluence-hipchat-emoticons/insertion/EmoticonInserter",
    [
        "ajs"
    ],
    function (
        AJS) {
    return {
        insertEmoticon: function(emoticon, type) {
            var editor = AJS.Rte.getEditor();

            if (type) {
                var $container = $(editor.getContainer());
                var source = null;
                if ($container.parents("#comments-section").length) {
                    source = "comment";
                }
                else if ($container.parents(".ic-comment-container").length) {
                    source = "inlinecomment";
                }
                else if ($container.parents("#editpageform").length || $container.parents("#createpageform").length) {
                    source = $container.parents(".blogpost").length ? "blog" : "page";
                }

                if (source) {
                    AJS.trigger("analyticsEvent", {
                        name: "confluence.hipchat.emoticons.insert."+type,
                        data: {
                            shortcut: emoticon.shortcut,
                            source: source
                        }
                    });
                }
            }

            // Slightly hacky - we determine if we're inserting a Confluence vs. HipChat emoticon by whether we have a
            // "name" attribute or not.
            var img = editor.dom.createHTML("img", emoticon.name ? {
                // Confluence emoticon.
                "src": emoticon.url,
                "alt": emoticon.name + " " + emoticon.shortcut,
                "title": emoticon.name + " " + emoticon.shortcut,
                "border": 0,
                "class": "emoticon emoticon-" + emoticon.name,
                "data-emoticon-name": emoticon.name
            } : {
                // HipChat emoticon.
                "src": emoticon.url,
                "alt": "(" + emoticon.shortcut + ")",
                "title": "(" + emoticon.shortcut + ")",
                "border": 0,
                "class": "emoticon emoticon-" + emoticon.shortcut,
                "data-hipchat-emoticon": emoticon.shortcut
            });

            editor.execCommand("mceInsertContent", false, img, {skip_undo: true});

            editor.undoManager.beforeChange();
            editor.undoManager.add();
        }
    };
});
