/**
 * @tainted tinymce
 */
define("confluence-hipchat-emoticons/completion/CompletionManager",
    [
        "ajs",
        "jquery",
        "underscore",
        "confluence-hipchat-emoticons/completion/Utilities",
        "confluence-hipchat-emoticons/data/DataManager",
        "confluence-hipchat-emoticons/insertion/EmoticonInserter"
    ],
    function (
        AJS,
        $,
        _,
        Utilities,
        DataManager,
        EmoticonInserter) {


        // This regex matches possible HipChat shortcuts: (foo). It does not match the closing parens as this regex is run
        // before that input is inserted into content.
        var possibleShortcutRegex = /\(([A-Za-z0-9]+)$/;
        var closingParensCharCode = 41;

        function handlePotentialEmoticonComplete(editor, nativeEvent) {
            var previousSiblingText = Utilities.getTextFromPreviousSiblingTextNodes(editor.selection.getRng(true));

            var possibleShortcut = possibleShortcutRegex.exec(previousSiblingText);
            if (!possibleShortcut) {
                return true;
            }

            possibleShortcut = possibleShortcut[1];

            var emoticon = DataManager.getHipChatEmoticon(possibleShortcut);

            if (!emoticon) {
                return true;
            }

            insertEmoticon(editor, emoticon);
            tinymce.dom.Event.cancel(nativeEvent);

            return false;
        }

        function getStartContainer(lengthOfMatch, currentTextNode, currentOffset) {
            var siblingParent, siblingIndex;
            if (!currentTextNode) {
                throw new Error("text node is null");
            }
            if (currentTextNode.nodeType != 3) {
                currentTextNode = currentTextNode.childNodes[currentOffset - 1];
                currentOffset = currentTextNode.length;
            }

            for (var ps = currentTextNode, runningOffset = currentOffset; ps && ps.nodeType == 3; ps = ps.previousSibling) {
                if (runningOffset == -1) {
                    runningOffset = ps.nodeValue.length;
                }

                if (runningOffset > lengthOfMatch) {
                    return {
                        container: ps,
                        offset: runningOffset - lengthOfMatch
                    };
                } else if (runningOffset == lengthOfMatch) {
                    siblingIndex = 0;
                    siblingParent = ps.parentNode;
                    while (ps.previousSibling) {
                        ps = ps.previousSibling;
                        siblingIndex++;
                    }
                    return {
                        container: siblingParent,
                        offset: siblingIndex
                    };
                } else {
                    lengthOfMatch -= runningOffset;
                    runningOffset = -1;
                }
            }

            return null;
        }

        function insertEmoticon(editor, emoticon) {
            var range,
                combinedText,
                matchGroups,
                matchGroupsOffset = 1,
                startContainerData,
                commonAncestor;

            editor.execCommand('mceInsertContent', false, ")");
            editor.undoManager.beforeChange();
            editor.undoManager.add();

            range = editor.selection.getRng(true);
            combinedText = Utilities.getTextFromPreviousSiblingTextNodes(range);

            startContainerData = getStartContainer(
                emoticon.shortcut.length + 1 + matchGroupsOffset, // shortcut.length + 1 for the opening parens.
                range.commonAncestorContainer,
                range.startOffset);

            range.setStart(startContainerData.container, startContainerData.offset);
            commonAncestor = $(range.commonAncestorContainer);
            editor.selection.setRng(range); //we have to set the editors selection now that we have modified the range to have text selected

            if (commonAncestor.closest(".wysiwyg-macro-body").length && range.toString() == commonAncestor.text()){
                //if the entire text of container node is selected and we're in a macro, don't let let the macro get deleted
                commonAncestor[0].innerHTML = "<br>";
                editor.selection.select(commonAncestor[0].childNodes[0]);
                editor.selection.collapse(true); //mceInsertContent throws an exception when only <br> is selected
            } else {
                //else delete the selection since the area will be kept cursor targetable by whatever else is there.
                editor.execCommand('delete', false, {}, {skip_undo: true});
            }

            EmoticonInserter.insertEmoticon(emoticon, "autoformat");
        }

        var editorKeypressHandler = function (editor, nativeEvent) {
            if (Utilities.getCharCode(nativeEvent) === closingParensCharCode) {
                return handlePotentialEmoticonComplete(editor, nativeEvent);
            }
        };

        return {
            start: function () {
                AJS.Rte.BootstrapManager.addOnInitCallback(function() {
                    AJS.Rte.getEditor().onKeyPress.addToTop(editorKeypressHandler);
                });
            }
        };
    });