require(['confluence/fh/utils/dom', 'confluence/fh/handlers/page-view-handler', 'ajs', 'jquery'], function (dom, handler, AJS, $) {
    'use strict';

    AJS.toInit(function () {
        // Only active on page which has content type
        if (!AJS.Meta.get('content-type')) {
            return;
        }

        // CONFDEV-36692 do not active if custom CSS is detected
        if ($('#main-content').find('style').length > 0) {
            return;
        }

        // Do not activate if we're in the doc theme
        if ($('body').hasClass('theme-documentation')) {
            return;
        }

        var $header = $('#header'),
                $mainHeader = $('#main-header'),
                $main = $('#main'),
                $content = $('#content'),
                $editPageLink = $('#editPageLink'),
                $actionMenuLink = $('#action-menu-link');

        var NON_PERSISTENCE_DIALOGS = [
            'inline-dialog-notifications-miniview',
            'inline-dialog-confluence-watch',
            'inline-dialog-shareContentPopup',
            'inline-dialog-ap-inline-dialog-content-confstats-connect-dev__confstats-live-watcher',
            'inline-dialog-jira-metadata-dialog'
        ];

        var closeOpeningDialogs = function () {
            var $openingDropDown = $('.aui-dropdown2[aria-hidden="false"]');
            $openingDropDown.length
                && $('.aui-dropdown2-trigger[aria-owns="' + $openingDropDown.attr('id') + '"]').trigger('aui-button-invoke');
            var $openingDialog = $('.aui-inline-dialog:visible');
            if ($openingDialog.length) {
                // Remove persistence dialogs from opening list
                $openingDialog = $openingDialog.filter(function () {
                    var $dialog = $(this);
                    var dialogId = $dialog.attr('id');
                    return $dialog.hasClass('non-persistence-dialog') || NON_PERSISTENCE_DIALOGS.indexOf(dialogId) !== -1;
                });
                $openingDialog.css({display: 'none'});
                var imageLinkClass = '.aui-button.active, .aui-nav-imagelink.active';
                $header.find(imageLinkClass).removeClass('active');
                $mainHeader.find(imageLinkClass).removeClass('active');
                // Remove focus for AUI buttons
                document.activeElement.blur();
            }
        };

        // Side bar show/hide/resize
        var mainObserver = new MutationObserver(function (mutations) {
            dom.adjustMainHeaderSize();
        });
        mainObserver.observe($main[0], {attributes: true, attributeFilter: ['style']});

        // Inline comment show/hide
        var contentObserver = new MutationObserver(function (mutations) {
            $content.css('padding-right') === '0px' && $content.css({paddingRight: '28px'});
        });
        contentObserver.observe($content[0], {attributes: true, attributeFilter: ['style']});

        // Auto resize header whenever window resizing
        $(window).on('resize.confluence-fixed-headers-responsive', AJS.debounce(dom.adjustMainHeaderSize, 100))
                .on('scroll', handler.onScrollHandler)
                // Close all current showing popup in header
                .scroll(AJS.debounceImmediate(closeOpeningDialogs, 250));

        if (handler.isKeepDotDotDotButton) {
            $main.addClass('floating-action-menu');
            $actionMenuLink.on('hover', handler.onHoverActionMenuLinkHandler);
        }

        $editPageLink.click(function () {
            contentObserver && contentObserver.disconnect();
            handler.onClickEditPageLinkHandler();
        });

        // Handle for Table of Contents
        setTimeout(function () {
            dom.scrollIfAnchor(window.location.hash);
        });

        $('body').on('click', 'a[href^="#"]', dom.scrollIfAnchor);
    });
});