/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;

public final class SoundData
extends RecordAtom {
    private static final int MAX_RECORD_LENGTH = 100000000;
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected SoundData() {
        this._data = new byte[0];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected SoundData(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = IOUtils.safelyAllocate(len - 8, 100000000);
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public byte[] getData() {
        return this._data;
    }

    @Override
    public long getRecordType() {
        return RecordTypes.SoundData.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    @Override
    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties("data", this::getData);
    }
}

