/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugins.conversion.annotation.ConversionPath;
import com.atlassian.confluence.plugins.conversion.api.ConversionManager;
import com.atlassian.confluence.plugins.conversion.api.ConversionResult;
import com.atlassian.confluence.plugins.conversion.api.ConversionResultSupplier;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.plugins.conversion.impl.ConfigurationProperties;
import com.atlassian.confluence.plugins.conversion.impl.ConversionManagerInternal;
import com.atlassian.confluence.plugins.conversion.impl.FileStoreConversionResultSupplier;
import com.atlassian.confluence.plugins.conversion.impl.FileStoreMode;
import com.atlassian.confluence.plugins.conversion.impl.LocalFileSystemConversionResultSupplier;
import com.atlassian.confluence.plugins.conversion.rest.ConfluenceConversionServiceResource;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.CapabilityService;
import com.atlassian.plugins.conversion.convert.FileFormat;
import com.atlassian.plugins.conversion.convert.image.AbstractConverter;
import com.atlassian.plugins.conversion.convert.image.CellsConverter;
import com.atlassian.plugins.conversion.convert.image.ImagingConverter;
import com.atlassian.plugins.conversion.convert.image.SlidesConverter;
import com.atlassian.plugins.conversion.convert.image.WordsConverter;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.sun.jersey.api.model.AbstractResource;
import com.sun.jersey.api.model.AbstractSubResourceMethod;
import com.sun.jersey.server.impl.modelapi.annotation.IntrospectionModeller;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={ConversionManager.class})
@Component(value="conversionManager")
public class DefaultConversionManager
implements ConversionManagerInternal {
    private static final Logger log = LoggerFactory.getLogger(DefaultConversionManager.class);
    private static final String BASE_REST_PATH = "/rest/documentConversion/latest/";
    private static final Map<ConversionType, String> URL_PREFIXES = new HashMap<ConversionType, String>();
    private static final Map<ConversionType, String> BATCH_URL_PREFIXES = new HashMap<ConversionType, String>();
    private AbstractConverter[] converters = null;
    private final ConversionResultSupplier fileStoreConversionResultSupplier;
    private final ConversionResultSupplier localFileSystemConversionResultSupplier;
    private final CapabilityService capabilityService;
    private final TransactionTemplate transactionTemplate;

    @Autowired
    public DefaultConversionManager(FileStoreConversionResultSupplier fileStoreConversionResultSupplier, LocalFileSystemConversionResultSupplier localFileSystemConversionResultSupplier, @ComponentImport CapabilityService capabilityService, @ComponentImport TransactionTemplate transactionTemplate) {
        this.capabilityService = capabilityService;
        this.transactionTemplate = transactionTemplate;
        this.fileStoreConversionResultSupplier = Objects.requireNonNull(fileStoreConversionResultSupplier);
        this.localFileSystemConversionResultSupplier = Objects.requireNonNull(localFileSystemConversionResultSupplier);
        fileStoreConversionResultSupplier.setConversionManager(this);
        localFileSystemConversionResultSupplier.setConversionManager(this);
    }

    @Override
    public void init() {
        if (this.isCloudEnabled()) {
            return;
        }
        Instant start = Instant.now();
        this.getConverters();
        Instant end = Instant.now();
        Duration loadTime = Duration.between(start, end);
        if (loadTime.minus(Duration.ofMinutes(1L)).isNegative()) {
            log.debug("ConversionManager initialised in {}s", (Object)loadTime.getSeconds());
        } else {
            log.info("ConversionManager initialised in {}m {}s", (Object)loadTime.toMinutes(), (Object)(loadTime.getSeconds() % 60L));
        }
    }

    @Override
    public boolean isConvertible(FileFormat fileFormat) {
        AbstractConverter[] converters;
        if (this.isCloudEnabled()) {
            return true;
        }
        if (fileFormat == null) {
            return false;
        }
        for (AbstractConverter converter : converters = this.getConverters()) {
            if (!converter.handlesFileFormat(fileFormat)) continue;
            return true;
        }
        return false;
    }

    private boolean isCloudEnabled() {
        return FileStoreMode.isFileStoreActive() || this.capabilityService.getHostApplication().hasCapability(ConfigurationProperties.PROP_CAPABILITY_CLOUD.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractConverter[] getConverters() {
        DefaultConversionManager defaultConversionManager = this;
        synchronized (defaultConversionManager) {
            if (this.converters == null) {
                this.converters = new AbstractConverter[]{new ImagingConverter(), new SlidesConverter(), new WordsConverter(), new CellsConverter()};
            }
        }
        return this.converters;
    }

    @Override
    public FileFormat getFileFormat(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        String contentType = attachment.getMediaType();
        if (contentType.isEmpty()) {
            return null;
        }
        String lowerContentType = contentType.toLowerCase();
        FileFormat tempFileFormat = FileFormat.fromMimeType((String)contentType.toLowerCase());
        if (tempFileFormat == null) {
            if (lowerContentType.equals("application/octet-stream") || lowerContentType.equals("application/x-upload-data")) {
                tempFileFormat = FileFormat.fromFileName((String)attachment.getFileName());
            }
            if (tempFileFormat == null) {
                return null;
            }
        }
        return tempFileFormat;
    }

    @Override
    public ConversionResult getConversionResult(Attachment attachment, ConversionType conversionType) {
        this.transactionTemplate.execute(() -> ((Attachment)attachment).getFileStoreId());
        switch (FileStoreMode.getValue()) {
            case MEDIA_ONLY: {
                return this.fileStoreConversionResultSupplier.getConversionResult(attachment, conversionType);
            }
            case DUAL_PRIMARY_MEDIA: {
                if (attachment.getFileStoreId() != null) {
                    return this.fileStoreConversionResultSupplier.getConversionResult(attachment, conversionType);
                }
            }
            case DUAL_PRIMARY_TICKET: 
            case TICKET_ONLY: {
                return this.localFileSystemConversionResultSupplier.getConversionResult(attachment, conversionType);
            }
        }
        throw new IllegalArgumentException("Invalid Cloud conversion mode:" + (Object)((Object)FileStoreMode.getValue()));
    }

    @Override
    public String getConversionUrl(long attachmentId, int version, ConversionType conversionType) {
        return URL_PREFIXES.get((Object)conversionType) + attachmentId + "/" + version;
    }

    @Override
    public String getBatchConversionUrl(ConversionType conversionType) {
        return BATCH_URL_PREFIXES.get((Object)conversionType);
    }

    static {
        AbstractResource resource = IntrospectionModeller.createResource(ConfluenceConversionServiceResource.class);
        String baseMethodPath = resource.getPath().getValue();
        for (AbstractSubResourceMethod method : resource.getSubResourceMethods()) {
            ConversionPath conversionPath = (ConversionPath)method.getAnnotation(ConversionPath.class);
            if (conversionPath == null) continue;
            ConversionType conversionType = conversionPath.value();
            String path = method.getPath().getValue();
            if (method.getHttpMethod().equals("GET")) {
                URL_PREFIXES.put(conversionType, BASE_REST_PATH + baseMethodPath + "/" + path.substring(0, path.indexOf(123)));
                continue;
            }
            if (!method.getHttpMethod().equals("POST")) continue;
            BATCH_URL_PREFIXES.put(conversionType, BASE_REST_PATH + baseMethodPath + "/" + path);
        }
    }
}

