/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl;

import java.util.concurrent.TimeUnit;

public enum ConfigurationProperties {
    PROP_CLOUD_CONNECTION_TIMEOUT("confluence.document.conversion.cloud.connection.timeout"),
    PROP_CLOUD_CONVERSION_TIMEOUT("confluence.document.conversion.cloud.conversion.timeout"),
    PROP_CLOUD_URL("confluence.document.conversion.cloud.url"),
    PROP_NUM_THREADS("confluence.document.conversion.threads"),
    PROP_NUM_THREADS_CLOUD("confluence.document.conversion.cloud.threads"),
    PROP_NUM_THREADS_WAIT("confluence.document.conversion.threads.wait"),
    PROP_NUM_THUMBNAIL_THREADS_WAIT("confluence.document.thumbnail.conversion.threads.wait"),
    PROP_NUM_THREADS_CLOUD_WAIT("confluence.document.conversion.cloud.threads.wait"),
    PROP_JVM_CONVERSIONS_ON_UPLOAD("confluence.document.conversion.jvm.onattach"),
    PROP_CAPABILITY("file.conversions"),
    PROP_CAPABILITY_CLOUD("file.conversions.cloud"),
    PROP_CONVERSION_QUEUE_THRESHOLD("confluence.document.conversion.queue.threshold"),
    PROP_SYSTEM_LOAD_RATIO("confluence.document.conversion.system.load.ratio"),
    PROP_USED_MEMORY_RATIO("confluence.document.conversion.used.memory.ratio");

    private static final int DEFAULT_CLOUD_CONNECTION_TIMEOUT;
    private static final int DEFAULT_CLOUD_CONVERSION_TIMEOUT;
    private final String property;

    private ConfigurationProperties(String property) {
        this.property = property;
    }

    public static int getDefaultInt(ConfigurationProperties property) {
        switch (property) {
            case PROP_NUM_THREADS: {
                return Math.max(1, Math.floorDiv(Runtime.getRuntime().availableProcessors(), 2));
            }
            case PROP_NUM_THREADS_CLOUD: {
                return Runtime.getRuntime().availableProcessors();
            }
            case PROP_NUM_THREADS_WAIT: 
            case PROP_NUM_THREADS_CLOUD_WAIT: {
                return 10000;
            }
            case PROP_NUM_THUMBNAIL_THREADS_WAIT: {
                return 1000;
            }
            case PROP_CLOUD_CONNECTION_TIMEOUT: {
                return DEFAULT_CLOUD_CONNECTION_TIMEOUT;
            }
            case PROP_CLOUD_CONVERSION_TIMEOUT: {
                return DEFAULT_CLOUD_CONVERSION_TIMEOUT;
            }
            case PROP_CONVERSION_QUEUE_THRESHOLD: {
                return 3;
            }
        }
        return -1;
    }

    public static double getDefaultDouble(ConfigurationProperties property) {
        switch (property) {
            case PROP_SYSTEM_LOAD_RATIO: {
                return 0.9;
            }
            case PROP_USED_MEMORY_RATIO: {
                return 0.8;
            }
        }
        return -1.0;
    }

    public static String getDefaultString(ConfigurationProperties property) {
        switch (property) {
            case PROP_CLOUD_URL: {
                return null;
            }
        }
        return null;
    }

    public static boolean getDefaultBoolean(ConfigurationProperties property) {
        switch (property) {
            case PROP_JVM_CONVERSIONS_ON_UPLOAD: {
                return false;
            }
        }
        return false;
    }

    public static String getString(ConfigurationProperties property) {
        switch (property) {
            case PROP_CLOUD_URL: {
                return ConfigurationProperties.getString(property.toString(), ConfigurationProperties.getDefaultString(property));
            }
        }
        return null;
    }

    private static String getString(String property, String defaultString) {
        String value = System.getProperty(property, defaultString);
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value.trim();
    }

    public static int getInt(ConfigurationProperties property) {
        switch (property) {
            case PROP_NUM_THREADS: 
            case PROP_NUM_THREADS_CLOUD: 
            case PROP_NUM_THREADS_WAIT: 
            case PROP_NUM_THREADS_CLOUD_WAIT: 
            case PROP_NUM_THUMBNAIL_THREADS_WAIT: 
            case PROP_CLOUD_CONNECTION_TIMEOUT: 
            case PROP_CONVERSION_QUEUE_THRESHOLD: {
                return Integer.getInteger(property.toString(), ConfigurationProperties.getDefaultInt(property));
            }
        }
        return -1;
    }

    public static double getDouble(ConfigurationProperties property) {
        switch (property) {
            case PROP_SYSTEM_LOAD_RATIO: 
            case PROP_USED_MEMORY_RATIO: {
                String value = System.getProperty(property.toString());
                if (value == null) {
                    return ConfigurationProperties.getDefaultDouble(property);
                }
                try {
                    return Double.valueOf(System.getProperty(property.toString()));
                }
                catch (NumberFormatException e) {
                    return ConfigurationProperties.getDefaultDouble(property);
                }
            }
        }
        return -1.0;
    }

    public static boolean getBoolean(ConfigurationProperties property) {
        switch (property) {
            case PROP_JVM_CONVERSIONS_ON_UPLOAD: {
                return System.getProperty(property.toString()) != null ? Boolean.getBoolean(property.toString()) : ConfigurationProperties.getDefaultBoolean(property);
            }
        }
        return false;
    }

    public String toString() {
        return this.property;
    }

    static {
        DEFAULT_CLOUD_CONNECTION_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(30L);
        DEFAULT_CLOUD_CONVERSION_TIMEOUT = (int)TimeUnit.MINUTES.toMillis(10L);
    }
}

