/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.api;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugins.conversion.api.ConversionData;
import com.atlassian.confluence.plugins.conversion.api.ConversionResult;
import com.atlassian.confluence.plugins.conversion.api.ConversionStatus;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.plugins.conversion.api.TrackingConversionData;
import com.atlassian.confluence.web.rangerequest.RangeNotSatisfiableException;
import com.atlassian.filestore.client.api.Failure;
import com.atlassian.filestore.client.api.FileStoreClient;
import com.atlassian.filestore.client.api.Success;
import com.atlassian.filestore.client.api.entity.Artifact;
import com.atlassian.filestore.client.api.entity.ArtifactType;
import com.atlassian.filestore.client.api.entity.ByteRange;
import com.atlassian.filestore.client.api.entity.ClientIdentity;
import com.atlassian.filestore.client.api.entity.File;
import com.atlassian.filestore.client.api.entity.FileResult;
import com.atlassian.filestore.client.api.entity.ProcessingStatus;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.conversion.convert.FileFormat;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.collect.ImmutableMap;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreConversionResult
extends ConversionResult {
    private static final Logger log = LoggerFactory.getLogger(FileStoreConversionResult.class);
    private final FileStoreClient fileStoreClient;
    private final ClientIdentity fileStoreClientIdentity;
    private final Supplier<ArtifactType> artifactType;
    private final Supplier<File> file;
    private static final Map<ProcessingStatus, ConversionStatus> conversionStatusMap = ImmutableMap.of((Object)ProcessingStatus.FAILED, (Object)((Object)ConversionStatus.ERROR), (Object)ProcessingStatus.PENDING, (Object)((Object)ConversionStatus.IN_PROGRESS), (Object)ProcessingStatus.RUNNING, (Object)((Object)ConversionStatus.IN_PROGRESS), (Object)ProcessingStatus.SUCCEEDED, (Object)((Object)ConversionStatus.CONVERTED));

    public FileStoreConversionResult(FileStoreClient fileStoreClient, ClientIdentity fileStoreClientIdentity, final Attachment attachment, final ConversionType conversionType, String conversionUrl) {
        super(attachment, conversionUrl);
        this.fileStoreClient = Objects.requireNonNull(fileStoreClient);
        this.fileStoreClientIdentity = Objects.requireNonNull(fileStoreClientIdentity);
        this.file = new LazyReference<File>(){

            protected File create() {
                String fileStoreId = attachment.getFileStoreId();
                if (fileStoreId == null || fileStoreId.equalsIgnoreCase("FILE_NOT_FOUND")) {
                    return null;
                }
                return FileStoreConversionResult.this.getFile();
            }
        };
        this.artifactType = new LazyReference<ArtifactType>(){

            protected ArtifactType create() {
                if (FileStoreConversionResult.this.file.get() == null) {
                    return null;
                }
                return FileStoreConversionResult.this.getArtifactType(conversionType, ((File)FileStoreConversionResult.this.file.get()).getMediaType());
            }
        };
    }

    private File getFile() {
        Either fileResult = this.fileStoreClient.getFile(this.fileStoreClientIdentity, this.attachment.getFileStoreId());
        if (fileResult.isLeft()) {
            Failure failure = (Failure)fileResult.left().get();
            log.error("Failed to retrieve status of file {} from FileStore: {}", new Object[]{this.attachment.getFileStoreId(), failure, failure.getCause().getOrNull()});
            return null;
        }
        return Objects.requireNonNull((File)((Success)fileResult.right().get()).getResult());
    }

    @Override
    public ConversionStatus getConversionStatus() {
        if (this.file.get() == null) {
            return ConversionStatus.ERROR;
        }
        if (this.artifactType.get() == null) {
            if (ProcessingStatus.SUCCEEDED.equals((Object)((File)this.file.get()).getProcessingStatus())) {
                return ConversionStatus.ERROR;
            }
            return conversionStatusMap.get(((File)this.file.get()).getProcessingStatus());
        }
        Option artifact = ((File)this.file.get()).getArtifact((ArtifactType)this.artifactType.get());
        if (artifact.isEmpty()) {
            return ConversionStatus.ERROR;
        }
        return conversionStatusMap.get(((Artifact)artifact.get()).getProcessingStatus());
    }

    @Override
    public ConversionData getConversionData(Optional<String> rangeHeader) throws RangeNotSatisfiableException, FileNotFoundException {
        Objects.requireNonNull((ArtifactType)this.artifactType.get(), "Cannot get conversionData, artifactType is not set.");
        Objects.requireNonNull(rangeHeader);
        if (!ConversionStatus.CONVERTED.equals((Object)this.getConversionStatus())) {
            throw new FileNotFoundException("File not converted");
        }
        final Optional<ByteRange> byteRange = rangeHeader.map(header -> () -> {
            try {
                return header.substring(6);
            }
            catch (IndexOutOfBoundsException e) {
                throw new RuntimeException("Range header malformed", e);
            }
        });
        return new TrackingConversionData(this.attachment, "fileStore", new ConversionData(){
            final FileResult fileResult;
            {
                this.fileResult = FileStoreConversionResult.this.getFileResult(byteRange);
            }

            @Override
            public StreamingOutput getStreamingOutput() {
                return outputStream -> {
                    try (InputStream inputStream = this.fileResult.getInputStream();){
                        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        outputStream.close();
                    }
                };
            }

            @Override
            public long getContentLength() {
                return this.fileResult.getContentLength();
            }

            @Override
            public Optional<String> getContentRange() {
                return Optional.ofNullable((String)this.fileResult.getContentRange().getOrNull());
            }

            @Override
            public String getContentType() {
                return this.fileResult.getContentType();
            }
        });
    }

    private FileResult getFileResult(Optional<ByteRange> byteRange) throws RangeNotSatisfiableException, FileNotFoundException {
        Either artifact;
        Either either = artifact = byteRange.isPresent() ? this.fileStoreClient.downloadArtifact(this.fileStoreClientIdentity, this.attachment.getFileStoreId(), (ArtifactType)this.artifactType.get(), byteRange.get()) : this.fileStoreClient.downloadArtifact(this.fileStoreClientIdentity, this.attachment.getFileStoreId(), (ArtifactType)this.artifactType.get());
        if (artifact.isLeft()) {
            Failure failure = (Failure)artifact.left().get();
            if (416 == (Integer)failure.getHttpStatusCode().getOrNull()) {
                throw new RangeNotSatisfiableException((String)failure.getMessage().getOrElse((Object)"Range not acceptable"));
            }
            if (Failure.Reason.FILE_NOT_FOUND.equals((Object)failure.getReason())) {
                throw new FileNotFoundException("File not converted: " + (failure.getCause().isDefined() ? ((Throwable)failure.getCause().get()).getMessage() : ""));
            }
            throw new RuntimeException(String.format("Failed to retrieve converted file from FileStore: %s", failure), (Throwable)failure.getCause().getOrNull());
        }
        return (FileResult)((Success)artifact.right().get()).getResult();
    }

    @Override
    public Optional<String> getContentType() {
        FileFormat fileFormat;
        if (this.artifactType.get() == null) {
            return Optional.empty();
        }
        switch ((ArtifactType)this.artifactType.get()) {
            case DOCUMENT_PDF: {
                fileFormat = FileFormat.PDF;
                break;
            }
            case DOCUMENT_TXT: {
                fileFormat = FileFormat.TXT;
                break;
            }
            case THUMBNAIL_120: 
            case THUMBNAIL_320: 
            case IMAGE: 
            case POSTER_640: 
            case POSTER_1280: {
                fileFormat = FileFormat.JPG;
                break;
            }
            case AUDIO: {
                fileFormat = FileFormat.MP3;
                break;
            }
            case VIDEO_640: 
            case VIDEO_1280: {
                fileFormat = FileFormat.MP4;
                break;
            }
            default: {
                throw new RuntimeException("artifactType not supported: " + ((ArtifactType)this.artifactType.get()).name());
            }
        }
        return Optional.of(fileFormat.getDefaultMimeType());
    }

    @Nullable
    private ArtifactType getArtifactType(ConversionType conversionType, String mediaType) {
        Objects.requireNonNull(conversionType);
        Objects.requireNonNull(mediaType);
        switch (conversionType) {
            case DOCUMENT: 
            case DOCUMENT_HD: {
                switch (mediaType) {
                    case "doc": {
                        return ArtifactType.DOCUMENT_PDF;
                    }
                    case "image": {
                        return ArtifactType.IMAGE;
                    }
                    case "video": {
                        return ConversionType.DOCUMENT_HD.equals((Object)conversionType) ? ArtifactType.VIDEO_1280 : ArtifactType.VIDEO_640;
                    }
                    case "audio": {
                        return ArtifactType.AUDIO;
                    }
                }
                return null;
            }
            case THUMBNAIL: {
                return ArtifactType.THUMBNAIL_320;
            }
            case POSTER: {
                return ArtifactType.POSTER_640;
            }
            case POSTER_HD: {
                return ArtifactType.POSTER_1280;
            }
        }
        throw new IllegalArgumentException("Conversion type " + (Object)((Object)conversionType) + " is not handled");
    }
}

