/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAuthors;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CommentsDocument;

public class CommentsTable
extends POIXMLDocumentPart {
    protected CTComments comments;

    public CommentsTable() {
        this.comments = CTComments.Factory.newInstance();
    }

    public CommentsTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            CommentsDocument doc = CommentsDocument.Factory.parse(is);
            this.comments = doc.getComments();
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        CommentsDocument doc = CommentsDocument.Factory.newInstance();
        doc.setComments(this.comments);
        doc.save(out, DEFAULT_XML_OPTIONS);
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public int getNumberOfComments() {
        return this.comments.getCommentList().sizeOfCommentArray();
    }

    public int getNumberOfAuthors() {
        return this.getCommentsAuthors().sizeOfAuthorArray();
    }

    public String getAuthor(long authorId) {
        return this.getCommentsAuthors().getAuthorArray((int)authorId);
    }

    public int findAuthor(String author) {
        for (int i = 0; i < this.getCommentsAuthors().sizeOfAuthorArray(); ++i) {
            if (!this.getCommentsAuthors().getAuthorArray(i).equals(author)) continue;
            return i;
        }
        return this.addNewAuthor(author);
    }

    public XSSFComment findCellComment(int row, int column) {
        return this.findCellComment(new CellReference(row, column).formatAsString());
    }

    public XSSFComment findCellComment(String cellRef) {
        for (CTComment comment : this.getCommentsList().getCommentArray()) {
            if (!cellRef.equals(comment.getRef())) continue;
            return new XSSFComment(this, comment);
        }
        return null;
    }

    public XSSFComment addComment() {
        return new XSSFComment(this, this.getCommentsList().addNewComment());
    }

    private CTCommentList getCommentsList() {
        if (this.comments.getCommentList() == null) {
            this.comments.addNewCommentList();
        }
        return this.comments.getCommentList();
    }

    private CTAuthors getCommentsAuthors() {
        if (this.comments.getAuthors() == null) {
            this.comments.addNewAuthors();
        }
        return this.comments.getAuthors();
    }

    private int addNewAuthor(String author) {
        int index = this.getCommentsAuthors().sizeOfAuthorArray();
        this.getCommentsAuthors().insertAuthor(index, author);
        return index;
    }

    public CTComments getCTComments() {
        return this.comments;
    }
}

