/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.extractor;

import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.xssf.model.Table;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.helpers.XSSFSingleXmlCell;
import org.apache.poi.xssf.usermodel.helpers.XSSFXmlColumnPr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSSFImportFromXML {
    private XSSFMap map;
    private static POILogger logger = POILogFactory.getLogger(XSSFImportFromXML.class);

    public XSSFImportFromXML(XSSFMap map) {
        this.map = map;
    }

    public void importFromXML(String xmlInputString) throws SAXException, XPathExpressionException {
        try {
            Object result;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmlInputString.trim())));
            List<XSSFSingleXmlCell> singleXmlCells = this.map.getRelatedSingleXMLCell();
            List<Table> tables = this.map.getRelatedTables();
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            final PrefixResolverDefault resolver = new PrefixResolverDefault(doc.getDocumentElement());
            NamespaceContext ctx = new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    return resolver.getNamespaceForPrefix(prefix);
                }

                public Iterator getPrefixes(String val) {
                    return null;
                }

                public String getPrefix(String uri) {
                    return null;
                }
            };
            xpath.setNamespaceContext(ctx);
            for (XSSFSingleXmlCell singleXmlCell : singleXmlCells) {
                String xpathString = singleXmlCell.getXpath();
                result = (Node)xpath.evaluate(xpathString, doc, XPathConstants.NODE);
                String textContent = result.getTextContent();
                logger.log(POILogger.DEBUG, "Extracting with xpath " + xpathString + " : value is '" + textContent + "'");
                XSSFCell cell = singleXmlCell.getReferencedCell();
                logger.log(POILogger.DEBUG, "Setting '" + textContent + "' to cell " + cell.getColumnIndex() + "-" + cell.getRowIndex() + " in sheet " + cell.getSheet().getSheetName());
                cell.setCellValue(textContent);
            }
            for (Table table : tables) {
                String commonXPath = table.getCommonXpath();
                result = (NodeList)xpath.evaluate(commonXPath, doc, XPathConstants.NODESET);
                int rowOffset = table.getStartCellReference().getRow() + 1;
                int columnOffset = table.getStartCellReference().getCol() - 1;
                for (int i = 0; i < result.getLength(); ++i) {
                    for (XSSFXmlColumnPr xmlColumnPr : table.getXmlColumnPrs()) {
                        XSSFCell cell;
                        int localColumnId = (int)xmlColumnPr.getId();
                        int rowId = rowOffset + i;
                        int columnId = columnOffset + localColumnId;
                        String localXPath = xmlColumnPr.getLocalXPath();
                        localXPath = localXPath.substring(localXPath.substring(1).indexOf(47) + 1);
                        String nodeXPath = commonXPath + "[" + (i + 1) + "]" + localXPath;
                        String value = (String)xpath.evaluate(nodeXPath, result.item(i), XPathConstants.STRING);
                        logger.log(POILogger.DEBUG, "Extracting with xpath " + nodeXPath + " : value is '" + value + "'");
                        XSSFRow row = table.getXSSFSheet().getRow(rowId);
                        if (row == null) {
                            row = table.getXSSFSheet().createRow(rowId);
                        }
                        if ((cell = row.getCell(columnId)) == null) {
                            cell = row.createCell(columnId);
                        }
                        logger.log(POILogger.DEBUG, "Setting '" + value + "' to cell " + cell.getColumnIndex() + "-" + cell.getRowIndex() + " in sheet " + table.getXSSFSheet().getSheetName());
                        cell.setCellValue(value.trim());
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}

