/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.listener;

import com.atlassian.confluence.event.events.content.attachment.AttachmentCreateEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentUpdateEvent;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.plugins.conversion.api.ConversionManager;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.plugins.conversion.impl.ConfigurationProperties;
import com.atlassian.confluence.plugins.conversion.impl.FileStoreMode;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugins.capabilities.api.CapabilityService;

public class CloudAttachmentListener {
    private final ConversionManager conversionManager;
    private final CapabilityService capabilityService;

    public CloudAttachmentListener(ConversionManager conversionManager, CapabilityService capabilityService) {
        this.conversionManager = conversionManager;
        this.capabilityService = capabilityService;
    }

    @EventListener
    public void handleCreateAttachment(AttachmentCreateEvent event) {
        this.startConversions((AttachmentEvent)event);
    }

    @EventListener
    public void handleUpdateAttachment(AttachmentUpdateEvent event) {
        this.startConversions((AttachmentEvent)event);
    }

    private void startConversions(AttachmentEvent event) {
        if (!this.cloudConversionsEnabled() && !this.jvmConversionsOnUploadEnabled() || FileStoreMode.isFileStorePrimary() && this.cloudConversionsEnabled()) {
            return;
        }
        for (Attachment attachment : event.getAttachments()) {
            this.conversionManager.getConversionResult(attachment, ConversionType.DOCUMENT);
        }
    }

    private boolean jvmConversionsOnUploadEnabled() {
        return ConfigurationProperties.getBoolean(ConfigurationProperties.PROP_JVM_CONVERSIONS_ON_UPLOAD);
    }

    private boolean cloudConversionsEnabled() {
        return this.capabilityService.getHostApplication().hasCapability(ConfigurationProperties.PROP_CAPABILITY_CLOUD.toString());
    }
}

