/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.impl.runnable.cloud;

import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.plugins.conversion.api.ConversionStatus;
import com.atlassian.confluence.plugins.conversion.api.ConversionType;
import com.atlassian.confluence.plugins.conversion.impl.ConfigurationProperties;
import com.atlassian.confluence.plugins.conversion.impl.FileSystemConversionState;
import com.atlassian.confluence.plugins.conversion.impl.runnable.cloud.CloudRequest;
import com.atlassian.confluence.plugins.conversion.impl.runnable.cloud.CloudRequestBuilder;
import com.atlassian.plugins.conversion.convert.FileFormat;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.util.concurrent.atomic.AtomicReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class CloudConversionRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CloudConversionRunnable.class);
    private static final int CHUNK_BUF_SIZE = 0x400000;
    private static final Marker MARKER_CLOUD = MarkerFactory.getMarker((String)"CloudConversion");
    private static final int HTTP_CLIENT_BUF_SIZE = 20480;
    private static final int CONNECTION_TIMEOUT = CloudConversionRunnable.getIntProperty(ConfigurationProperties.PROP_CLOUD_CONNECTION_TIMEOUT);
    private static final int SOCKET_TIMEOUT = CONNECTION_TIMEOUT * 3;
    private static final int CONVERSION_TIMEOUT = CloudConversionRunnable.getIntProperty(ConfigurationProperties.PROP_CLOUD_CONVERSION_TIMEOUT);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ResponseHandler<Integer> STATUS_CODE_RESPONSE_HANDLER = new ResponseHandler<Integer>(){

        public Integer handleResponse(HttpResponse response) throws IOException {
            return response.getStatusLine().getStatusCode();
        }
    };
    private static final int MIN_CONVERSION_POLLING_INTERVAL = (int)TimeUnit.MILLISECONDS.toMillis(500L);
    private static final int MAX_CONVERSION_POLLING_INTERVAL = (int)TimeUnit.SECONDS.toMillis(30L);
    private final String cloudUrl;
    private final Attachment attachment;
    private final AttachmentManager attachmentManager;
    private final HostApplication hostApplication;
    private final TransactionTemplate transactionTemplate;

    private static int getIntProperty(ConfigurationProperties property) {
        return Integer.getInteger(property.toString(), ConfigurationProperties.getDefaultInt(property));
    }

    public CloudConversionRunnable(String cloudUrl, Attachment attachment, AttachmentManager attachmentManager, HostApplication hostApplication, TransactionTemplate transactionTemplate) {
        this.cloudUrl = cloudUrl;
        this.attachment = attachment;
        this.attachmentManager = attachmentManager;
        this.hostApplication = hostApplication;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void run() {
        InputStream attachmentData = this.attachmentManager.getAttachmentData(this.attachment);
        if (attachmentData == null) {
            log.error(MARKER_CLOUD, "Failed to get attachment data stream for {}", (Object)this.attachment);
            return;
        }
        try {
            this.doCloudTicketConversion(this.attachment, attachmentData);
        }
        catch (IOException e) {
            log.error(MARKER_CLOUD, "Cannot do cloud conversion for {}. Reason: {}", (Object)this.attachment, (Object)e.getMessage());
            this.markAllAsError(this.attachment);
        }
        finally {
            IOUtils.closeQuietly((InputStream)attachmentData);
        }
    }

    private String getAuthToken() {
        return this.hostApplication.getId().toString();
    }

    private CloseableHttpClient buildCloudClient() {
        return HttpClients.custom().setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(20480).setCharset(Consts.UTF_8).build()).setUserAgent("Confluence").setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(SOCKET_TIMEOUT).build()).setDefaultRequestConfig(RequestConfig.custom().setCircularRedirectsAllowed(false).setConnectionRequestTimeout(CONNECTION_TIMEOUT).setConnectTimeout(CONNECTION_TIMEOUT).build()).useSystemProperties().build();
    }

    private String generateTicket(CloseableHttpClient client) throws IOException {
        log.debug(MARKER_CLOUD, "Getting ticket");
        CloudRequest<String> generateTicketRequest = CloudRequestBuilder.post(this.buildServerUrl("ticket"), String.class).requestName("generating ticket").client(client).authorisationToken(this.getAuthToken()).responseHandler(new ResponseHandler<String>(){

            public String handleResponse(HttpResponse response) throws IOException {
                Header location = response.getFirstHeader("Location");
                int statusCode = (Integer)STATUS_CODE_RESPONSE_HANDLER.handleResponse(response);
                if (statusCode != 201) {
                    throw new RuntimeException("Failed to generate ticket - unexpected HTTP response code " + statusCode);
                }
                if (location == null) {
                    throw new RuntimeException("Failed to generate ticket - did not receive a Location header");
                }
                return response.getFirstHeader("Location").getValue();
            }
        }).build();
        String ticketPath = generateTicketRequest.execute();
        log.debug(MARKER_CLOUD, "Ticket: {}", (Object)ticketPath);
        return ticketPath;
    }

    private boolean chunkExists(CloseableHttpClient client, String chunkPath) throws IOException {
        CloudRequest<Integer> chunkExistsRequest = CloudRequestBuilder.head(this.buildServerUrl(chunkPath), Integer.class).requestName("checking to see if chunk exists").client(client).authorisationToken(this.getAuthToken()).responseHandler(STATUS_CODE_RESPONSE_HANDLER).build();
        return chunkExistsRequest.execute() == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadChunk(CloseableHttpClient client, String chunkPath, byte[] data, int dataLength) throws IOException {
        try (ByteArrayInputStream dataInputStream = new ByteArrayInputStream(data, 0, dataLength);){
            CloudRequest<Integer> uploadChunkRequest = CloudRequestBuilder.put(this.buildServerUrl(chunkPath), Integer.class).requestName("uploading chunk").client(client).authorisationToken(this.getAuthToken()).contentType("application/octet-stream").entity((HttpEntity)new InputStreamEntity((InputStream)dataInputStream)).responseHandler(STATUS_CODE_RESPONSE_HANDLER).build();
            int statusCode = uploadChunkRequest.execute();
            if (statusCode != 200 && statusCode != 201) {
                throw new RuntimeException("Failed to upload chunk " + chunkPath + ". Code " + statusCode);
            }
        }
    }

    private void finishUpload(CloseableHttpClient client, String ticketPath, List<String> chunks) throws IOException {
        MultipartEntity multipartEntity = new MultipartEntity();
        multipartEntity.addPart(new FormBodyPart("file_name", (ContentBody)new StringBody(this.attachment.getFileName())));
        multipartEntity.addPart(new FormBodyPart("mimetype", (ContentBody)new StringBody(this.attachment.getMediaType())));
        multipartEntity.addPart(new FormBodyPart("chunks", (ContentBody)new StringBody(this.toJsonString(chunks))));
        CloudRequest<Integer> finishUploadRequest = CloudRequestBuilder.put(this.buildServerUrl(ticketPath), Integer.class).requestName("finishing file upload").client(client).authorisationToken(this.getAuthToken()).entity((HttpEntity)multipartEntity).responseHandler(STATUS_CODE_RESPONSE_HANDLER).build();
        int statusCode = finishUploadRequest.execute();
        if (statusCode != 201 && statusCode != 200) {
            throw new RuntimeException("Failed to finish file upload. Code " + statusCode);
        }
        log.debug(MARKER_CLOUD, "{}: Finished upload", (Object)ticketPath);
    }

    private void cancelTicket(CloseableHttpClient client, String ticketPath) throws IOException {
        CloudRequest<Void> cancelTicket = CloudRequestBuilder.delete(this.buildServerUrl(ticketPath)).requestName("cancelling ticket").client(client).authorisationToken(this.getAuthToken()).build();
        cancelTicket.execute();
    }

    private void submitFileForConversion(CloseableHttpClient client, String ticketPath, InputStream data) throws IOException {
        int currentChunkSize;
        ArrayList chunkChecksums = Lists.newArrayList();
        byte[] buf = new byte[0x400000];
        while ((currentChunkSize = data.read(buf)) > 0) {
            String checksum = this.generateChecksum(buf, currentChunkSize);
            chunkChecksums.add(checksum + "-" + currentChunkSize);
            String chunkPath = ticketPath + "/" + checksum + "?resumableCurrentChunkSize=" + currentChunkSize;
            if (this.chunkExists(client, chunkPath)) continue;
            log.debug(MARKER_CLOUD, "{}: Uploading chunk {} ({})", new Object[]{ticketPath, checksum, currentChunkSize});
            this.uploadChunk(client, chunkPath, buf, currentChunkSize);
        }
        this.finishUpload(client, ticketPath, chunkChecksums);
    }

    private int waitForConversion(CloseableHttpClient client, String ticketPath) throws IOException {
        int statusCode;
        long conversionShouldFinishBefore = System.currentTimeMillis() + (long)CONVERSION_TIMEOUT;
        int sleepDuration = MIN_CONVERSION_POLLING_INTERVAL;
        int inProgressStatus = ConversionStatus.IN_PROGRESS.getStatus();
        int busyStatus = ConversionStatus.BUSY.getStatus();
        do {
            CloudRequest<Integer> conversionStatusCheckRequest;
            if ((statusCode = (conversionStatusCheckRequest = CloudRequestBuilder.head(this.buildServerUrl(ticketPath), Integer.class).requestName("polling conversion status").client(client).authorisationToken(this.getAuthToken()).responseHandler(STATUS_CODE_RESPONSE_HANDLER).build()).execute().intValue()) != inProgressStatus && statusCode != busyStatus) continue;
            try {
                Thread.sleep(sleepDuration);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Sleep interrupted while waiting for conversion");
            }
            sleepDuration = Math.min(2 * sleepDuration, MAX_CONVERSION_POLLING_INTERVAL);
            if (System.currentTimeMillis() <= conversionShouldFinishBefore) continue;
            throw new RuntimeException("Timed out waiting " + TimeUnit.MILLISECONDS.toSeconds(CONVERSION_TIMEOUT) + "s for conversion to finish");
        } while (statusCode == inProgressStatus || statusCode == busyStatus);
        return statusCode;
    }

    private DTResponse getConversionDetails(CloseableHttpClient client, String ticketPath) throws IOException {
        CloudRequest<DTResponse> conversionStatusCheckRequest = CloudRequestBuilder.get(this.buildServerUrl(ticketPath), DTResponse.class).requestName("getting conversion details").client(client).authorisationToken(this.getAuthToken()).responseHandler(new ResponseHandler<DTResponse>(){

            public DTResponse handleResponse(HttpResponse response) throws IOException {
                int responseCode = (Integer)STATUS_CODE_RESPONSE_HANDLER.handleResponse(response);
                if (responseCode != 200) {
                    throw new RuntimeException("Failed to get conversion details. Code " + responseCode);
                }
                return (DTResponse)OBJECT_MAPPER.readValue(response.getEntity().getContent(), DTResponse.class);
            }
        }).build();
        log.debug(MARKER_CLOUD, "{}: Getting file details", (Object)ticketPath);
        return conversionStatusCheckRequest.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCloudTicketConversion(Attachment attachment, InputStream data) throws IOException {
        CloseableHttpClient client = this.buildCloudClient();
        try {
            String ticketPath = this.generateTicket(client);
            this.storeTicketId(attachment.getId(), ticketPath);
            try {
                this.submitFileForConversion(client, ticketPath, data);
            }
            catch (RuntimeException e) {
                log.error("Failed to submit file for conversion. Attempting to cancel conversion.", (Throwable)e);
                this.cancelTicket(client, ticketPath);
                throw e;
            }
            int conversionResponseCode = this.waitForConversion(client, ticketPath);
            if (conversionResponseCode != ConversionStatus.CONVERTED.getStatus()) {
                log.error(MARKER_CLOUD, "{}: Cannot convert (HTTP code: {}, file extension: {}, mime type; {})", new Object[]{ticketPath, conversionResponseCode, attachment.getFileExtension(), attachment.getMediaType()});
                this.markAllAsError(attachment);
            } else {
                DTResponse fileInfo = this.getConversionDetails(client, ticketPath);
                List<ConversionType> requiredConversionTypes = this.getRequiredConversionTypes(fileInfo, ticketPath);
                for (ConversionType conversionType : requiredConversionTypes) {
                    log.debug(MARKER_CLOUD, "{}: Getting {}", (Object)ticketPath, (Object)conversionType);
                    try {
                        this.getAndSaveConvertedFile(attachment, conversionType, fileInfo.result, client, ticketPath);
                    }
                    catch (RuntimeException ex) {
                        this.markError(attachment, conversionType);
                        String reason = ex instanceof WebApplicationException ? "(" + ((WebApplicationException)ex).getResponse().getStatus() + ")" : "";
                        if (!conversionType.isOptional()) {
                            log.error(MARKER_CLOUD, "{}: Can't retrieve '{}' {}", new Object[]{ticketPath, conversionType, reason});
                        } else {
                            log.debug(MARKER_CLOUD, "{}: Can't retrieve '{}' (but marked as optional) {}", new Object[]{ticketPath, conversionType, reason});
                        }
                        log.debug(MARKER_CLOUD, "Exception:", (Throwable)ex);
                    }
                }
                for (ConversionType conversionType : ConversionType.values()) {
                    if (requiredConversionTypes.contains((Object)conversionType)) continue;
                    this.markError(attachment, conversionType);
                }
            }
            log.debug(MARKER_CLOUD, "{}: Finished conversion", (Object)ticketPath);
        }
        finally {
            try {
                client.close();
            }
            catch (Exception e) {
                log.error(MARKER_CLOUD, "Cannot dispose connection", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    List<ConversionType> getRequiredConversionTypes(DTResponse response, String ticketPath) {
        ArrayList<ConversionType> conversionTypes = new ArrayList<ConversionType>();
        if (response.error != null) {
            log.error(MARKER_CLOUD, "{}: Conversion error: {}", (Object)ticketPath, (Object)response.error.name);
            this.markAllAsError(this.attachment);
        } else if (response.result == null) {
            log.error(MARKER_CLOUD, "{}: Result response was null", (Object)ticketPath);
            this.markAllAsError(this.attachment);
        } else if ("unknown".equals(response.result.media_type)) {
            log.debug(MARKER_CLOUD, "{}: Unknown format", (Object)ticketPath);
            this.markAllAsError(this.attachment);
        } else {
            conversionTypes.add(ConversionType.THUMBNAIL);
            boolean isVideo = "video".equals(response.result.media_type);
            boolean isAudio = "audio".equals(response.result.media_type);
            if (isVideo || isAudio) {
                conversionTypes.add(ConversionType.POSTER);
            }
            conversionTypes.add(ConversionType.DOCUMENT);
            if (isVideo) {
                conversionTypes.add(ConversionType.POSTER_HD);
                conversionTypes.add(ConversionType.DOCUMENT_HD);
            }
        }
        return conversionTypes;
    }

    private void storeTicketId(final long attachmentId, final String ticketPath) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                Attachment attachmentInSession = CloudConversionRunnable.this.attachmentManager.getAttachment(attachmentId);
                if (attachmentInSession != null) {
                    attachmentInSession.getProperties().setStringProperty("CONVERSION_TICKET", ticketPath);
                }
                return null;
            }
        });
    }

    private void markAllAsError(Attachment attachment) {
        for (ConversionType conversionType : ConversionType.values()) {
            this.markError(attachment, conversionType);
        }
    }

    private void getAndSaveConvertedFile(final Attachment attachment, final ConversionType conversionType, DTResponse.DTSuccessResponse fileInfo, CloseableHttpClient client, String ticketPath) throws IOException {
        String path;
        String mediaType = fileInfo.media_type;
        final AtomicReference mimeTypeRef = new AtomicReference();
        switch (conversionType) {
            case POSTER: 
            case POSTER_HD: {
                path = String.format("%s/poster_%d.jpg", ticketPath, conversionType == ConversionType.POSTER_HD ? 1280 : 640);
                mimeTypeRef.set((Object)FileFormat.JPG.getDefaultMimeType());
                break;
            }
            case THUMBNAIL: {
                path = ticketPath + "/thumb_320.jpg";
                mimeTypeRef.set((Object)FileFormat.JPG.getDefaultMimeType());
                break;
            }
            case DOCUMENT: 
            case DOCUMENT_HD: {
                FileTypeInfo fileTypeInfo = FileTypeInfo.fromMediaType(mediaType);
                if (fileTypeInfo == null) {
                    throw new RuntimeException(ticketPath + ": Unknown media type (" + mediaType + ")");
                }
                mimeTypeRef.set((Object)fileTypeInfo.getMimeType());
                log.debug(MARKER_CLOUD, "{}: Document format is {}", (Object)ticketPath, (Object)fileTypeInfo.getExtension());
                if ("video".equals(fileTypeInfo.getDocName())) {
                    path = String.format("%s/%s_%d.%s", ticketPath, fileTypeInfo.getDocName(), conversionType == ConversionType.DOCUMENT_HD ? 1280 : 640, fileTypeInfo.getExtension());
                    break;
                }
                path = ticketPath + "/" + fileTypeInfo.getDocName() + "." + fileTypeInfo.getExtension();
                break;
            }
            default: {
                throw new IllegalArgumentException("Conversion type " + (Object)((Object)conversionType) + " is not handled");
            }
        }
        final File inProgressFile = FileSystemConversionState.getStatusFileWithExtension(attachment, conversionType, ConversionStatus.IN_PROGRESS);
        CloudRequest<Void> getConvertedFileRequest = CloudRequestBuilder.get(this.buildServerUrl(path)).requestName("downloading converted document").client(client).authorisationToken(this.getAuthToken()).responseHandler(new ResponseHandler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void handleResponse(HttpResponse response) throws IOException {
                File fConverted;
                int responseStatus = (Integer)STATUS_CODE_RESPONSE_HANDLER.handleResponse(response);
                if (responseStatus != 200) {
                    throw new WebApplicationException(responseStatus);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(inProgressFile);
                try {
                    HttpEntity responseEntity = response.getEntity();
                    responseEntity.writeTo((OutputStream)fileOutputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)fileOutputStream);
                }
                String mimeTypeStr = (String)mimeTypeRef.get();
                if (mimeTypeStr != null) {
                    FileOutputStream mimeFos = new FileOutputStream(new FileSystemConversionState(attachment, conversionType).getConvertedFile().toString() + "mime");
                    try {
                        mimeFos.write(mimeTypeStr.getBytes());
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)mimeFos);
                    }
                }
                if ((fConverted = FileSystemConversionState.getStatusFileWithExtension(attachment, conversionType, ConversionStatus.CONVERTED)).exists()) {
                    try {
                        boolean deleted = fConverted.delete();
                        if (!deleted) {
                            return null;
                        }
                    }
                    catch (Exception ignored) {
                        return null;
                    }
                }
                FileUtils.moveFile((File)inProgressFile, (File)fConverted);
                return null;
            }
        }).build();
        getConvertedFileRequest.execute();
    }

    private void markError(Attachment attachment, ConversionType conversionType) {
        new FileSystemConversionState(attachment, conversionType).markAsError();
    }

    private String toJsonString(List<String> chunks) {
        Gson gson = new Gson();
        return gson.toJson(chunks);
    }

    private String generateChecksum(byte[] buffer, int length) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        digester.update(buffer, 0, length);
        byte[] binaryHash = digester.digest();
        return Hex.encodeHexString((byte[])binaryHash);
    }

    private String buildServerUrl(String path) {
        if (this.cloudUrl.endsWith("/") && path.endsWith("/")) {
            return this.cloudUrl.concat(path.substring(1));
        }
        if (this.cloudUrl.endsWith("/") || path.startsWith("/")) {
            return this.cloudUrl.concat(path);
        }
        return this.cloudUrl.concat("/").concat(path);
    }

    @VisibleForTesting
    static class FileTypeInfo {
        private static final FileTypeInfo docFileTypeInfo = new FileTypeInfo("pdf", "document", FileFormat.PDF.getDefaultMimeType());
        private static final FileTypeInfo imageFileTypeInfo = new FileTypeInfo("jpg", "image", FileFormat.JPG.getDefaultMimeType());
        private static final FileTypeInfo videoFileTypeInfo = new FileTypeInfo("mp4", "video", FileFormat.MP4.getDefaultMimeType());
        private static final FileTypeInfo audioFileTypeInfo = new FileTypeInfo("mp3", "audio", FileFormat.MP3.getDefaultMimeType());
        private final String extension;
        private final String docName;
        private final String mimeType;

        public static FileTypeInfo fromMediaType(String mediaType) {
            if ("doc".equals(mediaType)) {
                return docFileTypeInfo;
            }
            if ("image".equals(mediaType)) {
                return imageFileTypeInfo;
            }
            if ("video".equals(mediaType)) {
                return videoFileTypeInfo;
            }
            if ("audio".equals(mediaType)) {
                return audioFileTypeInfo;
            }
            return null;
        }

        public FileTypeInfo(String extension, String docName, String mimeType) {
            this.extension = extension;
            this.docName = docName;
            this.mimeType = mimeType;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getDocName() {
            return this.docName;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileTypeInfo that = (FileTypeInfo)o;
            if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
                return false;
            }
            if (this.docName != null ? !this.docName.equals(that.docName) : that.docName != null) {
                return false;
            }
            return !(this.mimeType != null ? !this.mimeType.equals(that.mimeType) : that.mimeType != null);
        }

        public int hashCode() {
            int result = this.extension != null ? this.extension.hashCode() : 0;
            result = 31 * result + (this.docName != null ? this.docName.hashCode() : 0);
            result = 31 * result + (this.mimeType != null ? this.mimeType.hashCode() : 0);
            return result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @VisibleForTesting
    static class DTResponse {
        public DTErrorResponse error;
        public DTSuccessResponse result;

        DTResponse() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        static class DTSuccessResponse {
            public String id;
            public String name;
            public String extension;
            public long size;
            public long time_added;
            public String media_type;
            public String processing_status;
            public Map<String, Object> meta;

            DTSuccessResponse() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        static class DTErrorResponse {
            public String name;

            DTErrorResponse() {
            }
        }
    }
}

