/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.extract.xml;

import com.atlassian.bonnie.search.SearchableAttachment;
import com.atlassian.bonnie.search.extractor.ExtractorException;
import com.atlassian.bonnie.search.extractor.util.AbstractLengthLimitedStringBuilder;
import com.atlassian.bonnie.search.extractor.util.LimitReachedException;
import com.atlassian.bonnie.search.extractor.util.StaticLengthLimitedStringBuilder;
import com.atlassian.confluence.plugins.conversion.extract.xml.SecureXmlUtils;
import com.atlassian.plugins.conversion.extract.xml.AbstractXMLExtractor;
import com.atlassian.util.profiling.UtilTimerStack;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpreadsheetXMLExtractor
extends AbstractXMLExtractor {
    private static final Logger log = LoggerFactory.getLogger(SpreadsheetXMLExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractText(InputStream inputStream, int maxSize, SearchableAttachment attachment) throws ExtractorException {
        try {
            spf = SecureXmlUtils.createSecureSAXParserFactory();
            parser = spf.newSAXParser();
            parser.getXMLReader().setEntityResolver(SecureXmlUtils.emptyEntityResolver);
        }
        catch (Exception e) {
            throw new ExtractorException("could not create SAX parser", (Throwable)e);
        }
        try {
            UtilTimerStack.push((String)"extractText() -- Pass 1 - Read shared strings");
            zin = new ZipInputStream(attachment.getContentsAsStream());
            strings = new ArrayList<String>();
            ** try [egrp 2[TRYBLOCK] [2 : 69->132)] { 
lbl13:
            // 1 sources

            ** GOTO lbl-1000
lbl14:
            // 1 sources

            finally {
                IOUtils.closeQuietly((InputStream)zin);
            }
        }
        catch (IOException e) {
            throw new ExtractorException("Error reading content of Excel document: " + e.getMessage(), (Throwable)e);
        }
lbl-1000:
        // 3 sources

        {
            while ((ze = zin.getNextEntry()) != null) {
                parser.reset();
                if (!ze.getName().equals("xl/sharedStrings.xml")) continue;
                try {
                    SpreadsheetXMLExtractor.parseSharedStrings(parser, ze, zin, strings);
                }
                catch (LimitReachedException e) {
                    SpreadsheetXMLExtractor.log.info("Not enough memory to read '{}'. The attachment won't be searchable.", (Object)attachment.getFileName());
                    var8_11 = "";
                    IOUtils.closeQuietly((InputStream)zin);
                    return var8_11;
                }
            }
        }
        UtilTimerStack.pop((String)"extractText() -- Pass 1 - Read shared strings");
        UtilTimerStack.push((String)"extractText() -- Pass 2 - Build output string");
        zin = new ZipInputStream(attachment.getContentsAsStream());
        outputBuffer = new StaticLengthLimitedStringBuilder(maxSize);
        try {
            while ((ze = zin.getNextEntry()) != null) {
                parser.reset();
                if (ze.getName().equals("xl/sharedStrings.xml")) continue;
                SpreadsheetXMLExtractor.parseEntry(parser, ze, zin, (AbstractLengthLimitedStringBuilder)outputBuffer, strings);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zin);
        }
        UtilTimerStack.pop((String)"extractText() -- Pass 2 - Build output string");
        if (outputBuffer.isLimitReached()) {
            SpreadsheetXMLExtractor.log.info("Not enough memory to extract all text from '{}'. The attachment will be partially searchable.", (Object)attachment.getFileName());
        }
        return outputBuffer.toString();
    }

    private static void parseSharedStrings(SAXParser parser, ZipEntry ze, final ZipInputStream zin, ArrayList<String> strings) throws ExtractorException {
        log.debug("parsing shared strings [ {} ]", (Object)ze.getName());
        BufferedInputStream in = new BufferedInputStream((InputStream)zin){

            @Override
            public void close() throws IOException {
                zin.closeEntry();
            }
        };
        try {
            SharedStringsHandler sharedStringsHandler = new SharedStringsHandler(strings);
            parser.parse((InputStream)in, (DefaultHandler)sharedStringsHandler);
        }
        catch (LimitReachedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExtractorException("Could not create SAX Parser", (Throwable)e);
        }
    }

    private static void parseEntry(SAXParser parser, ZipEntry ze, final ZipInputStream zin, AbstractLengthLimitedStringBuilder outputBuffer, List<String> strings) throws ExtractorException {
        if (!ze.getName().endsWith(".xml")) {
            log.debug("skipping [ {} ]", (Object)ze.getName());
            return;
        }
        log.debug("parsing [ {} ]", (Object)ze.getName());
        try {
            BufferedInputStream in = new BufferedInputStream((InputStream)zin){

                @Override
                public void close() throws IOException {
                    zin.closeEntry();
                }
            };
            parser.parse((InputStream)in, (DefaultHandler)new PartHandler(outputBuffer, strings));
        }
        catch (Exception e) {
            throw new ExtractorException("Could not create SAX Parser", (Throwable)e);
        }
    }

    private static class SharedStringsHandler
    extends DefaultHandler {
        private boolean capturingString = false;
        private final ArrayList<String> strings;
        private final StringBuilder buffer;
        private int uniqueCount;

        public SharedStringsHandler(ArrayList<String> strings) {
            this.strings = strings;
            this.buffer = new StringBuilder(524288);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("t")) {
                this.capturingString = true;
            } else if (qName.equals("sst")) {
                this.uniqueCount = Integer.valueOf(attributes.getValue("uniqueCount"));
                this.strings.ensureCapacity(this.uniqueCount);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.capturingString) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("t")) {
                this.strings.add(this.buffer.toString());
                this.buffer.setLength(0);
                this.capturingString = false;
            }
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.strings.size() != this.uniqueCount) {
                log.error("expected [ {} ] entries but read [ {} ]", (Object)this.uniqueCount, (Object)this.strings.size());
            } else {
                log.debug("read [ {} ] shared strings", (Object)this.strings.size());
            }
        }
    }

    private static class PartHandler
    extends DefaultHandler {
        private final AbstractLengthLimitedStringBuilder outputBuffer;
        private List<String> strings;
        private String capturingElement = null;
        private CapturingType type = null;
        private StringBuilder buffer = new StringBuilder(128);

        public PartHandler(AbstractLengthLimitedStringBuilder outputBuffer, List<String> strings) {
            this.outputBuffer = outputBuffer;
            this.strings = strings;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("c") || qName.equals("si")) {
                this.type = "s".equals(attributes.getValue("t")) ? CapturingType.INDEXED : CapturingType.LITERAL;
                log.debug("capturing [ {} ]", (Object)qName);
                this.capturingElement = qName;
            } else if (qName.equals("sheet")) {
                this.appendToOutput(attributes.getValue("name"));
            } else {
                log.debug("skipping [ {} ]", (Object)qName);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.capturingElement != null) {
                this.buffer.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.capturingElement != null && qName.equals(this.capturingElement)) {
                this.capturingElement = null;
                switch (this.type) {
                    case INDEXED: {
                        int index = Integer.parseInt(this.buffer.toString());
                        this.appendToOutput(this.strings.get(index));
                        break;
                    }
                    case LITERAL: {
                        this.appendToOutput(this.buffer.toString());
                    }
                }
                this.type = null;
                this.buffer.setLength(0);
            }
        }

        private void appendToOutput(String s) {
            this.outputBuffer.append(' ').append(s);
        }
    }

    private static enum CapturingType {
        INDEXED,
        LITERAL;

    }
}

