/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.conversion.dom;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.migration.ExceptionTolerantMigrator;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.plugins.conversion.dom.ConfluenceUtilities;
import com.atlassian.plugins.conversion.confluence.dom.ImportContext;
import com.atlassian.plugins.conversion.confluence.dom.doc2wiki.splitter.BookmarkInfo;
import com.atlassian.plugins.conversion.confluence.parser.ConfluenceImage;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DefaultImportContext
implements ImportContext {
    protected AbstractPage _page;
    protected AbstractPage _oldPage;
    protected final AttachmentManager _attachmentManager;
    protected final BookmarkInfo _bookmarks;
    protected final PageManager _pageManager;
    private final Dimension maxImportImageSize;

    public DefaultImportContext(PageManager pageManager, AbstractPage page, AbstractPage oldPage, AttachmentManager attachmentManager, BookmarkInfo bookmarks, Dimension maxImportImageSize) {
        this._pageManager = pageManager;
        this._page = page;
        this._oldPage = oldPage;
        this._attachmentManager = attachmentManager;
        this._bookmarks = bookmarks;
        this.maxImportImageSize = maxImportImageSize;
    }

    public String createHyperlinkReference(StringBuffer codeBuf) {
        String ref = this.parseFieldCode(codeBuf);
        if (ref == null) {
            return "";
        }
        if (this._bookmarks.get(ref = ref.replace("\\\\", "\\")) != null) {
            ref = '#' + ref;
        } else if (ref.startsWith("//")) {
            ref = "http:" + ref;
        }
        return ref;
    }

    public boolean imageExists(ConfluenceImage parser) {
        return ConfluenceUtilities.findImage(this._pageManager, this._page, parser.getSpaceKey(), parser.getPageName(), parser.getImgName()) != null;
    }

    public void importImage(String fileName, String contentType, byte[] buf) throws IOException {
        if (this._page.getAttachmentNamed(fileName) == null) {
            Attachment imgFile = new Attachment(fileName, contentType, (long)buf.length, "imported from a Word document");
            this._page.addAttachment(imgFile);
            this._attachmentManager.saveAttachment(imgFile, null, (InputStream)new ByteArrayInputStream(buf));
        }
    }

    public Dimension getMaxImportedImageSize() {
        return this.maxImportImageSize;
    }

    protected String parseFieldCode(StringBuffer codeBuf) {
        int linkStart = codeBuf.indexOf("\"");
        int linkEnd = -1;
        if (linkStart != -1 && linkStart < codeBuf.length() - 1) {
            linkEnd = codeBuf.indexOf("\"", linkStart + 1);
            ++linkStart;
        } else {
            linkStart = codeBuf.indexOf("HYPERLINK");
            if (linkStart != -1) {
                linkStart += 9;
                while (linkStart < codeBuf.length() && Character.isWhitespace(codeBuf.charAt(linkStart))) {
                    ++linkStart;
                }
            }
            linkEnd = codeBuf.length();
        }
        String ref = null;
        if (linkStart != -1 && linkEnd != -1 && linkStart != linkEnd) {
            ref = codeBuf.substring(linkStart, linkEnd);
            int bookmarkIdx = codeBuf.indexOf("\\l", linkEnd + 1);
            if (bookmarkIdx != -1 && (linkStart = codeBuf.indexOf("\"", bookmarkIdx)) != -1 && linkStart < codeBuf.length() - 1 && (linkEnd = codeBuf.indexOf("\"", linkStart + 1)) != -1 && linkStart != linkEnd) {
                ref = ref + '#' + codeBuf.substring(linkStart + 1, linkEnd);
            }
        }
        return ref;
    }

    public void finish(StringBuilder out) {
        if (this._page == null) {
            return;
        }
        ExceptionTolerantMigrator migrator = (ExceptionTolerantMigrator)ContainerManager.getComponent((String)"wikiToXhtmlMigrator");
        ExceptionTolerantMigrator.MigrationResult migrationResult = migrator.migrate(out.toString(), (ConversionContext)new DefaultConversionContext((RenderContext)this._page.toPageContext()));
        String migratedBody = migrationResult.getContent();
        this._page.setBodyAsString(migratedBody);
        if (this._oldPage == null) {
            this._pageManager.saveContentEntity((ContentEntityObject)this._page, null);
        } else {
            this._pageManager.saveContentEntity((ContentEntityObject)this._page, (ContentEntityObject)this._oldPage, null);
            this._oldPage = null;
        }
    }
}

